package com.mlc.nordic_sdk.screen

import com.mlc.nordic_sdk.viewModel.WBPActivityViewModel
import android.annotation.SuppressLint
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.safeDrawingPadding
import androidx.compose.foundation.layout.wrapContentWidth
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.lazy.rememberLazyListState
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.livedata.observeAsState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import kotlinx.coroutines.launch

@OptIn(ExperimentalMaterial3Api::class)
@SuppressLint("UnrememberedMutableState")
@Composable
fun WBPScreen(viewModel: WBPActivityViewModel) {
    val state by mutableStateOf(viewModel.state)
    val data by viewModel.listData.observeAsState(initial = emptyList())

    Scaffold(topBar = { TopBar("WBP") }, modifier = Modifier.safeDrawingPadding()) {
        Column(
            modifier = Modifier
                .padding(it)
                .fillMaxWidth(),
            horizontalAlignment = Alignment.CenterHorizontally
        ) {
            when(state) {
                true -> {
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.readDiagnosticModeHistory() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read diagnostic mode history", fontSize = 10.sp)
                        }
                        Button(
                            onClick = { viewModel.clearCurrentModeHistory() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Clear current mode history", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.readUsualModeHistory() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read usual mode history", fontSize = 10.sp)
                        }
                        Button(
                            onClick = { viewModel.clearSelectedModeHistory() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Clear selected mode history", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.disconnectBluetooth() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Disconnect", fontSize = 10.sp)
                        }
                        Button(
                            onClick = { viewModel.readDeviceIDAndInfo() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read device ID and info", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.writeDeviceTime() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Write device time", fontSize = 10.sp)
                        }
                        Button(
                            onClick = { viewModel.readDeviceTime() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read device time", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.readUserIDAndVersionData() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read user ID and version data", fontSize = 10.sp)
                        }
                        Button(
                            onClick = { viewModel.writeNewUserID() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Write new user ID", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.readMeasurementSetting() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read measurement setting", fontSize = 10.sp)
                        }
                        Button(
                            onClick = { viewModel.writeMeasurementSetting() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Write measurement setting", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.readSerialNumber() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read SN", fontSize = 10.sp)
                        }
                    }
                    Row(modifier = Modifier.fillMaxWidth()) {
                        Button(
                            onClick = { viewModel.readUsualModeHistoryEachMeasurement() }, modifier = Modifier
                                .weight(1f)
                                .padding(5.dp)) {
                            Text(text = "Read usual mode history data each measurement", fontSize = 10.sp)
                        }
                    }
                }
                else -> {}
            }
            Text(
                text = "Log",
                modifier = Modifier
                    .background(Color.Gray)
                    .fillMaxWidth()
                    .wrapContentWidth(Alignment.CenterHorizontally)
            )

            // Remember a CoroutineScope to be able to launch
            val listState = rememberLazyListState()
            val coroutineScope = rememberCoroutineScope()

            LazyColumn(
                state = listState,
                modifier = Modifier
                    .fillMaxWidth()
            ) {
                items(data) { index ->
                    TextItem(
                        text = index,
                        modifier = Modifier
                            .fillMaxWidth()
                            .border(1.dp, color = Color(220, 220, 220))
                    )
                }
                coroutineScope.launch {
                    // Animate scroll to the last item
                    listState.animateScrollToItem(index = data.size)
                }
            }
        }
    }
}