//
//  BSViewController.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by willy.wu on 2022/4/26.
//  Copyright © 2022 WiFi@MBP. All rights reserved.
//

#import "BSViewController.h"

@interface BSViewController ()

@end

@implementation BSViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self viewHidden:0];
    [self connectBGM700];
    [self connectBGM800];
    NSArray *devices = @[self.bgm800,self.bgm700];
    [self.sdk device:devices];
    kWeakSelf(self)
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
        if ([weakself.bgm800 isEqual:device]) {
            [weakself.bgm800 connectDevice];
        }
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
        [weakself viewHidden:0];
        [weakself.sdk startScan];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
        [weakself viewHidden:0];
        [weakself.sdk startScan];
    }];
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*2);
    self.bsView.contentSize = CGSizeMake(self.bsView.frame.size.width, self.bsView.frame.size.height*2);
}

- (void)viewHidden:(NSInteger)ss {
    switch (ss) {
        case 1:
            self.bsView.hidden = YES;
            self.butView.hidden = NO;
            break;
        case 2:
            self.bsView.hidden = NO;
            self.butView.hidden = YES;
            break;
        default:
            self.bsView.hidden = self.butView.hidden = YES;
            break;
    }
}

#pragma mark - IBAction
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    [self addLogWhitText:log];
    switch (sender.tag) {
        case 100:
            [self.bgm800 readDeviceName];
            break;
        case 101:
            [self.bgm800 readFWVersion];
            break;
        case 102:
            [self.bgm800 getBLEStatus];
            break;
        case 103:
            [self.bgm800 readLastData];
            break;
        case 104:
            if (self.value2Text.text.integerValue > 0) {
                [self.bgm800 readData:self.value2Text.text.integerValue];
            }
            break;
        case 105:
            [self.bgm800 readDataLength];
            break;
        case 106:
            [self.bgm800 disconnect];
            break;
        case 107:
            [self.bgm800 readDateTime];
            break;
        case 200:
            [self.bgm700 QueryMachineFunction];
            break;
        case 201:
            [self.bgm700 QueryUricAcidDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 202:
            [self.bgm700 QueryCholesterolDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 203:
            [self.bgm700 QueryBloodKetoneDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 204:
            [self.bgm700 QueryGKIDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 205:
            [self.bgm700 QueryLactateDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 206:
            [self.bgm700 QueryBloodGlucoseDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 207:
            [self.bgm700 QueryHemeDatas:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 208:
            [self.bgm700 DownloadBloodGlucoseData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 209:
            [self.bgm700 DownloadUricAcidData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 210:
            [self.bgm700 DownloadCholesterolData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 211:
            [self.bgm700 DownloadBloodKetoneData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 212:
            [self.bgm700 DownloadGKIData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 213:
            [self.bgm700 DownloadLactateData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        case 214:
            [self.bgm700 DownloadHemeData:PARAMAll SN1:@(self.value1Text.text.integerValue) SN2:@(self.value2Text.text.integerValue)];
            break;
        default:
            break;
    }
}


- (void)connectBGM800 {
    kWeakSelf(self)
    self.dataLength = 1;
    self.bgm800 = [MicroLifeBGM800 shareWhithAuthorizationkey:SDKkey_BS];
    [self.bgm800 autoConnect:NO];
    [self.bgm800 deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.bgm800];
        [weakself addLogWhitText:log];
        [weakself viewHidden:1];
    }];
    [self.bgm800 getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.bgm800 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bgm800 CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDBGM800ReadDataLength:
                [weakself addValue1:nil Value2:((MicroLifeBGM800MeasureData *)model).recordCounts.stringValue];
                break;
            case CMDBGM800ReadDeviceName:
                [weakself addValue1:((MicroLifeDeviceInfo *)model).BTModuleName Value2:nil];
                break;
            case CMDBGM800ReadFWVersion:
            case CMDBGM800BLEStatus:
            case CMDBGM800ReadData:
            case CMDBGM800ReadNewData:
            case CMDBGM800ReadHistorysData:
            case CMDBGM800ReadLastData:
            case CMDBGM800Disconnect:
            case CMDBGM800ReadDateTime:
                break;
            default:
                break;
        }
    }];
}

- (void)connectBGM700 {
    kWeakSelf(self)
    self.bgm700 = [MicroLifeBGM700 shareWhithAuthorizationkey:SDKkey_BS];
    [self.bgm700 deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.bgm700];
        [weakself addLogWhitText:log];
        [weakself viewHidden:2];
    }];
    [self.bgm700 getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.bgm700 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bgm700 CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDBGM700QueryMachineFunction:
                break;
            case CMDBGM700QueryBloodGlucoseDatas:
            case CMDBGM700QueryUricAcidDatas:
            case CMDBGM700QueryCholesterolDatas:
            case CMDBGM700QueryBloodKetoneDatas:
            case CMDBGM700QueryGKIDatas:
            case CMDBGM700QueryLactateDatas:
            case CMDBGM700QueryHemeDatas:
                [weakself addValue1:((MicroLifeDeviceInfo *)model).maxMemory.stringValue Value2:nil];
                break;
            case CMDBGM700DownloadBloodGlucoseData:
            case CMDBGM700DownloadUricAcidData:
            case CMDBGM700DownloadCholesterolData:
            case CMDBGM700DownloadBloodKetoneData:
            case CMDBGM700DownloadGKIData:
            case CMDBGM700DownloadLactateData:
            case CMDBGM700DownloadHemeData:
                break;
            default:
                break;
        }
    }];
}

- (void)addValue1:(id)value1 Value2:(id)value2 {
    self.value1Text.text = value1?:@"";
    self.value2Text.text = value2?:@"";
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
