//
//  IdeabusPickView.h
//  Health
//
//  Created by WiFi@ on 2017/12/11.
//  Copyright © 2017年 WiFi@MBP. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef void(^confirmBlock) (id item);
typedef void(^cancelBlock) (id item);
typedef void(^changedBlock) (id item);
typedef void(^hideBlock)(void);

@interface IdeabusPickView : UIView

@property (nonatomic, strong) UIPickerView   *pickerView;
@property (nonatomic, strong) UIDatePicker   *datePickerView;

@property (nonatomic, strong) UIPickerView   *countryPickerView;

/**
 以plist建構pickView

 @param plistName plistName
 @param selectedData 起始位置
 @param titleName 名稱
 @param confirmButtonName 左側按鈕
 @param confirmBlock 左側按鈕動作
 @param cancelButtonName 右側按鈕
 @param cancelBlock 右側按鈕動作
 @param hideBlock 隱藏動作
 @return pickView
 */
- (instancetype)initWithPlistName:(NSString *)plistName
                     selectedItem:(id)selectedData
                        titleName:(NSString *)titleName
                confirmButtonName:(NSString *)confirmButtonName
                     confirmBlock:(confirmBlock)confirmBlock
                 cancelButtonName:(NSString *)cancelButtonName
                      cancelBlock:(cancelBlock)cancelBlock
                        hideBlock:(hideBlock)hideBlock;

/**
 以數組建構pickView

 @param dataSource 數組
 @param selectedData 起始位置
 @param titleName 名稱
 @param confirmButtonName 左側按鈕
 @param confirmBlock 左側按鈕動作
 @param cancelButtonName 右側按鈕
 @param cancelBlock 右側按鈕動作
 @param hideBlock 隱藏動作
 @return pickView
 */
- (instancetype)initWithDataSource:(NSArray *)dataSource
                      selectedItem:(id)selectedData
                         titleName:(NSString *)titleName
                 confirmButtonName:(NSString *)confirmButtonName
                      confirmBlock:(confirmBlock)confirmBlock
                  cancelButtonName:(NSString *)cancelButtonName
                       cancelBlock:(cancelBlock)cancelBlock
                         hideBlock:(hideBlock)hideBlock;

/**
 建立DatePicker

 @param mode DatePicker類型
 @param format 時間格式
 @param currentDate 起始時間
 @param minDate 最小時間
 @param maxDate 最大時間
 @param titleName 名稱
 @param confirmButtonName 左側按鈕
 @param confirmBlock 左側按鈕動作
 @param cancelButtonName 右側按鈕
 @param cancelBlock 右側按鈕動作
 @param hideBlock 隱藏動作
 @return datePicker
 */
- (instancetype)initDatePickerWithMode:(UIDatePickerMode)mode
                            dateFormat:(NSString *)format
                              showDate:(NSString *)currentDate
                           minimumDate:(NSString *)minDate
                           maximumDate:(NSString *)maxDate
                             titleName:(NSString *)titleName
                     confirmButtonName:(NSString *)confirmButtonName
                          confirmBlock:(confirmBlock)confirmBlock
                      cancelButtonName:(NSString *)cancelButtonName
                           cancelBlock:(cancelBlock)cancelBlock
                             hideBlock:(hideBlock)hideBlock;

/**
 Country PickView

 @param selectedCountry 起始國家
 @param titleName 名稱
 @param confirmButtonName 左側按鈕
 @param confirmBlock 左側按鈕動作
 @param cancelButtonName 右側按鈕
 @param cancelBlock 右側按鈕動作
 @param hideBlock 隱藏動作
 @return pickView
 */
- (instancetype)initWithSelectedCountry:(NSString *)selectedCountry
                              titleName:(NSString *)titleName
                      confirmButtonName:(NSString *)confirmButtonName
                           confirmBlock:(confirmBlock)confirmBlock
                       cancelButtonName:(NSString *)cancelButtonName
                            cancelBlock:(cancelBlock)cancelBlock
                              hideBlock:(hideBlock)hideBlock;
;
/**
 顯示
 */
- (void)show;

/**
 移除
 
 @param completion 移除完成的Block
 */
- (void)hide:(hideBlock)completion;


/**
 選擇時

 @param completion 選擇時的Block
 */
- (void)changed:(changedBlock)completion;


/**
 移動到特定起始值

 @param animated 使用動畫效果
 */
- (void)pickerViewSelectRowWithAnimated:(BOOL)animated;

@end
