//
//  IdeabusToolBox.h
//  baseCode
//
//  Created by WiFi@MBP on 2017/10/11.
//  Copyright © 2017年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <sys/utsname.h>                         //讀取設備資訊
#import <UIKit/UIKit.h>
#import <CommonCrypto/CommonDigest.h>
#import <CommonCrypto/CommonCrypto.h>
#import <objc/runtime.h>
#import <UserNotifications/UserNotifications.h> //ios10推播
#import <SafariServices/SafariServices.h>
#import <StoreKit/StoreKit.h>                   //App Store 内部直接評分

//Model

//專案通用工具

//全局宏

//Category

//第三方庫

//cocoaPods



/// 是否横竖屏
/// 用户界面横屏了才会返回YES
#define IS_LANDSCAPE [IdeabusToolBox isLandscape]
/// 无论支不支持横屏，只要设备横屏了，就会返回YES
#define IS_DEVICE_LANDSCAPE UIDeviceOrientationIsLandscape([[UIDevice currentDevice] orientation])

/// 屏幕宽度，跟横竖屏无关
#define DEVICE_WIDTH (IS_LANDSCAPE ? [[UIScreen mainScreen] bounds].size.height : [[UIScreen mainScreen] bounds].size.width)

/// 屏幕高度，跟横竖屏无关
#define DEVICE_HEIGHT (IS_LANDSCAPE ? [[UIScreen mainScreen] bounds].size.width : [[UIScreen mainScreen] bounds].size.height)

/**
 *  沙盒位置
 */
typedef NS_ENUM(NSInteger) {
    Root = 0,
    Documents,
    Libaray,
    Caches,
    Preferences,
    Tmp,
} SandBoxs;

typedef NS_ENUM(NSInteger) {
    InchScreenUnknown,
    InchScreen35,
    InchScreen40,
    InchScreen47,
    InchScreen54,
    InchScreen55,
    InchScreen58,
    InchScreen61,
    InchScreen63,
    InchScreen65,
    InchScreen67,
    InchScreen69,
    InchScreen79,
    InchScreen83,
    InchScreen97,
    InchScreen102,
    InchScreen105,
    InchScreen109,
    InchScreen111,
    InchScreen129,
    InchScreen130
} InchScreenType;

/**
 ColorType 隨機顏色類型表:

 - ColorDarkBlack: ⚫️ 極暗/黑        (0%~25% 亮度) 深色背景底色
 - ColorDark:      🟤 暗色/濁色      (25%~50% 亮度) 次要文字、深色標籤
 - ColorWarm:      🟠 柔和/暖色      (50%~75% 亮度) 一般按鈕、溫馨提示
 - ColorBright:    ⚪️ 高亮/粉嫩      (75%~100% 亮度) 深色模式下的文字、高光背景
 - ColorPrimary:   🎨 全域隨機       (0%~100% 亮度) 原始隨機邏輯 (較不可控)
 - ColorGolden:    🌈 均勻分佈       (黃金比例) 列表 (List)、圖表 (Charts)、連續標籤
 - ColorHSB:       🍬 糖果色        (高質感隨機) 大頭貼 (Avatar)、Icon 背景
 */
typedef NS_ENUM(NSInteger, ColorType) {
    ColorDarkBlack = 0,
    ColorDark,
    ColorWarm,
    ColorBright,
    ColorPrimary,
    ColorGolden,
    ColorHSB
};

@interface IdeabusToolBox : NSObject

#pragma mark - 系統類
/**
 獲取系統UUID(使用KeyChain記錄)

 @return 獲取系統UUID(使用KeyChain記錄)
 */
+ (NSString * _Nullable)ib_GetDeviceUUID;

/**
 檢測系統版本

 @return 系統版本
 */
+ (NSString * _Nullable)ib_SeeSystemVersion;

/**
 檢查是否為特定系統版本

 @param sv 目標版本號
 @return 是否>=目標版本號
 */
+ (BOOL)ib_IsSystemVersion:(float)sv;

/**
 系統目前使用語言

 @return 系統目前使用語言
 */
+ (NSString * _Nullable)ib_Language;

/**
系統目前使用地區

@return 系統目前使用地區
*/
+ (NSString * _Nullable)ib_CountryCode;


/// <#Description#>
+ (BOOL)isLandscape;

/**
 檢查螢幕尺寸

 @return 檢查螢幕尺寸
 */
+ (InchScreenType)GetInchScreenType;

/**
 判斷是否為带物理凹槽的刘海屏或者使用 Home Indicator 类型的设备
 
 @return 是否為带物理凹槽的刘海屏或者使用 Home Indicator 类型的设备
 */
+ (BOOL)isNotchedScreen;

/**
 判斷是否為可NFC執行設備

 @return 是否為可NFC執行設備
 */
+ (BOOL)ib_IsNFCWorking;

#pragma mark 設備型號
+ (NSString * _Nullable)deviceModel;

#pragma mark - 加/解密類
/**
 *  MD5加密
 *
 *  @param str 字串
 *
 *  @return MD5加密字串
 */
+ (NSString * _Nullable)ib_MD5:(NSString * _Nullable)str;

/**
 *  SHA1加密
 *
 *  @param str 字串
 *
 *  @return SHA1加密字串
 */
+ (NSString * _Nullable)ib_SHA1:(NSString * _Nullable)str;

/**
 *  SHA256加密
 *
 *  @param str 字串
 *
 *  @return SHA256加密字串
 */
+ (NSString * _Nullable)ib_SHA256:(NSString * _Nullable)str;

/**
 *  SHA512加密
 *
 *  @param str 字串
 *
 *  @return SHA512加密字串
 */
+ (NSString * _Nullable)ib_SHA512:(NSString * _Nullable)str;

/**
 Base64加密（NSString）
 
 @param string 字串
 @return Base64加密字串
 */
+ (NSString * _Nullable)ib_Base64EncodedString:(NSString * _Nullable)string;

/**
 Base64加密（NSData）
 
 @param sourceData 數據
 @return Base64加密字串
 */
+ (NSString * _Nullable)ib_Base64EncodingWithData:(NSData * _Nullable)sourceData;

/**
 Base64解密（NSString）
 
 @param string 加密字串
 @return Base64解密字串
 */
+ (NSString * _Nullable)ib_Base64DecodedString:(NSString * _Nullable)string;

/**
 Base64解密（NSData）
 
 @param sourceString 加密字串
 @return Base64解密數據
 */
+ (id _Nullable)ib_Base64EncodingWithString:(NSString * _Nullable)sourceString;

/**
 *  DES加密（NSData）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param data      加密數據
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return DES加密數據
 */
+ (NSData * _Nullable)ib_DESEncryptData:(NSData * _Nullable)data
                    keyString:(NSString * _Nullable)keyString
                           iv:(NSString * _Nullable)ivString;

/**
 *  DES加密（NSString）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param string    加密字串
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return DES加密字串
 */
+ (NSString * _Nullable)ib_DESEncryptString:(NSString * _Nullable)string
                        keyString:(NSString * _Nullable)keyString
                               iv:(NSString * _Nullable)ivString;

/**
 *  DES解密（NSData）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param data      解密數據
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return DES解密數據
 */
+ (NSData * _Nullable)ib_DESDecryptData:(NSData * _Nullable)data
                    keyString:(NSString * _Nullable)keyString
                           iv:(NSString * _Nullable)ivString;

/**
 *  DES解密（NSString）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param string    解密字串
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return DES解密字串
 */
+ (NSString * _Nullable)ib_DESDecryptString:(NSString * _Nullable)string
                        keyString:(NSString * _Nullable)keyString
                               iv:(NSString * _Nullable)ivString;

/**
 *  AES加密（NSData）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param data      加密數據
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return AES加密數據
 */
+ (NSData * _Nullable)ib_AESEncryptData:(NSData * _Nullable)data
                    keyString:(NSString * _Nullable)keyString
                           iv:(NSString * _Nullable)ivString;

/**
 *  AES加密（NSString）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param string    加密字串
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return AES加密字串
 */
+ (NSString * _Nullable)ib_AESEncryptString:(NSString * _Nullable)string
                        keyString:(NSString * _Nullable)keyString
                               iv:(NSString * _Nullable)ivString;

/**
 *  AES解密（NSData）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param data      解密數據
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return AES解密數據
 */
+ (NSData * _Nullable)ib_AESDecryptData:(NSData * _Nullable)data
                    keyString:(NSString * _Nullable)keyString
                           iv:(NSString * _Nullable)ivString;

/**
 *  AES解密（NSString）
 *  方法出處：XHTeng/XHCryptorTools https://github.com/XHTeng/XHCryptorTools
 *  @param string    解密字串
 *  @param keyString 密鑰字符串
 *  @param ivString  向量
 *
 *  @return AES解密字串
 */
+ (NSString * _Nullable)ib_AESDecryptString:(NSString * _Nullable)string
                        keyString:(NSString * _Nullable)keyString
                               iv:(NSString * _Nullable)ivString;

#pragma mark - 檔案存取類
/**
 *  取得應用沙盒位置:0.Root;1.Documents;2.Libaray;3.Caches;4.Preferences;5.Tmp;
 *
 *  @param key      文件目錄選擇
 *  @param fileName 文件資料夾名稱
 *
 *  0.Root:根目錄;
 *  1.Documents:保存應用運行時生成的需要持久化的數據，iTunes會自動備份該目錄。;
 *  2.Libaray:存儲程序的默認設置和其他狀態信息，iTunes會自動備份該目錄。;
 *  3.Caches:存放緩存文件，iTunes不會備份此目錄，此目錄下文件不會在應用退出刪除，一般存放體積比較大，不是很重要的資源。;
 *  4.Preferences:保存應用的所有偏好設置，ios的Settings（設置）應用會在該目錄中查找應用的設置信息，iTunes會自動備份該目錄。;
 *  5.Tmp:保存應用運行時所需的臨時數據，使用完畢後再將相應的文件從該目錄刪除，應用沒有運行時，系統也可能會自動清理該目錄下的文件，iTunes不會同步該目錄，iPhone重啟時該目錄下的文件會丟失。;
 *
 *  @return 應用沙盒文件目錄位置
 */
+ (NSString * _Nullable)ib_GetSandBox:(SandBoxs)key
                   FileName:(NSString * _Nullable)fileName;

/**
 *  建立檔案路經:0.Root;1.Documents;2.Libaray;3.Caches;4.Preferences;5.Tmp;
 *
 *  @param fileName     檔案名稱
 *  @param FilePathName 文件資料夾名稱
 *  @param key          文件目錄選擇參數
 *
 *  @return 建立檔案路經
 */
+ (NSString * _Nullable)ib_SetFileName:(NSString * _Nullable)fileName
                saveFilePath:(NSString * _Nullable)FilePathName
             saveFilePathKey:(SandBoxs)key;

/**
 *  檢查檔案存在
 *
 *  @param filePath 檢查檔案路徑
 *
 *  @return         是否存在
 */
+ (BOOL)ib_CheckingFile:(NSString * _Nullable)filePath;

/**
 *  刪除檔案
 *
 *  @param filePath 刪除檔案路徑
 */
+ (void)ib_DeleteFile:(NSString * _Nullable)filePath;

#pragma mark - NSUserDefaults存取類
/**
 *  將變量存至NSUserDefaults
 *
 *  @param value 儲存變量
 *  @param key   儲存變量名
 */
+ (void)ib_SaveNSUserDefaults:(id _Nullable)value
                          Key:(NSString * _Nullable)key;

/**
 *  從NSUserDefaults讀取變量
 *
 *  @param key 讀取變量名
 *
 *  @return 讀取變量
 */
+ (id _Nullable)ib_ReadNSUserDefaults:(NSString * _Nullable)key;

/**
 從NSUserDefaults刪除資料
 
 @param key 刪除變量名
 */
+ (void)ib_DeleteNSUserDefaults:(NSString * _Nullable)key;

/**
 判斷NSUserDefaults 某個key值是否存
 
 @param key 判斷變量名
 @return 是否存
 */
+ (BOOL)ib_DetermineNSUserDefaultExist:(NSString * _Nullable)key;

/**
 刪除所有NSUserDefaults
 */
+ (void)ib_RemoveAllDefaultData;

#pragma mark - Plist存取類
/**
 *  讀取設定用plist資料
 *
 *  @param key 設定欄位名
 *
 *  @return 設定資料
 */
+ (id _Nullable)ib_AppMetaDataWithKey:(NSString * _Nullable)key;

/**
 *  將變量存至本地Plist文件
 *
 *  @param value    變量值
 *  @param key      變量名
 *  @param fileName 本地Plist文件名稱
 */
+ (void)ib_WriteToPlist:(id _Nullable)value
                    key:(NSString * _Nullable)key
               fileName:(NSString * _Nullable)fileName;

/**
 *  讀取本地Plist文件某個變量的值
 *
 *  @param key      變量名
 *  @param fileName 本地Plist文件名稱
 */
+ (id _Nullable)ib_ReadFromPlistByKey:(NSString * _Nullable)key
                   fileName:(NSString * _Nullable)fileName;

/**
 *  刪除本地Plist文件某個變量
 *
 *  @param key      變量名
 *  @param fileName 本地Plist文件名稱
 */
+ (void)ib_RemoveFromPlistByKey:(NSString * _Nullable)key
                       fileName:(NSString * _Nullable)fileName;

#pragma mark - 圖片處理類
/**
 以等比例大小，縮放圖片
 
 @param image 處理照片
 @param rectsize 比例大小
 @param scale 使用螢幕倍率
 @return 縮放圖片
 */
+ (UIImage * _Nullable)ib_ScaleImage:(UIImage * _Nullable)image
                    toSize:(CGSize)rectsize
                     Scale:(BOOL)scale;

/**
 以縮放倍率，縮放圖片
 
 @param image 處理照片
 @param scaleSize 縮放倍率
 @param scale 使用螢幕倍率
 @return 縮放圖片
 */
+ (UIImage * _Nullable)ib_ScaleImage:(UIImage * _Nullable)image
                   toScale:(float)scaleSize
                     Scale:(BOOL)scale;

/**
 以固定寬度，縮放圖片
 
 @param image 處理照片
 @param width 固定寬度
 @param scale 使用螢幕倍率
 @return 縮放圖片
 */
+ (UIImage * _Nullable)ib_ScaleImage:(UIImage * _Nullable)image
                   byWidth:(CGFloat)width
                     Scale:(BOOL)scale;

/**
 以固定高度，縮放圖片
 
 @param image 處理照片
 @param height 固定高度
 @param scale 使用螢幕倍率
 @return 縮放圖片
 */
+ (UIImage * _Nullable)ib_ScaleImage:(UIImage * _Nullable)image
                  byHeight:(CGFloat)height
                     Scale:(BOOL)scale;

/**
 兩張圖覆盖合成圖片：maskImage合成上圖
 
 @param image 合成底圖
 @param maskImage 合成上圖
 @param scale 使用螢幕倍率
 @return 合成圖片
 */
+ (UIImage* _Nullable)ib_MaskImage:(UIImage * _Nullable)image
                withMask:(UIImage * _Nullable)maskImage
                   Scale:(BOOL)scale;

/**
 對於特定UIView的截圖
 
 @param view 目標UIView
 @param scale 使用螢幕倍率
 @return 截圖
 */
+ (UIImage* _Nullable)ib_CaptureView:(UIView * _Nullable)view
                     Scale:(BOOL)scale;

/**
 固定框架圖片（留白居中圖）
 
 @param image 原圖
 @param size 框架大小
 @param scale 使用螢幕倍率
 @return 固定框架圖片
 */
+(UIImage * _Nullable)ib_FitSquareImage:(UIImage * _Nullable)image
                       toSize:(CGSize)size
                        Scale:(BOOL)scale;

/**
 固定滿版圖片(填滿居中圖)
 
 @param image   原圖
 @param size    框架大小
 @param scale   使用螢幕倍率
 @return        固定滿版圖片
 */
+(UIImage * _Nullable)ib_FillSquareImage:(UIImage * _Nullable)image
                        toSize:(CGSize)size
                         Scale:(BOOL)scale;

/**
 將圖剪裁呈圓形圖
 
 @param image       原圖
 @param borderWidth 圓形邊框線寬
 @param borderColor 圓形邊框線色
 @param scale       使用螢幕倍率
 @return            剪裁圖
 */
+ (UIImage * _Nullable)ib_CircleImageWithImage:(UIImage * _Nullable)image
                         borderWidth:(CGFloat)borderWidth
                         borderColor:(UIColor * _Nullable)borderColor
                               Scale:(BOOL)scale;

/**
 顏色轉圖片
 
 @param color 顏色
 @param rectsize 大小
 @param scale 使用螢幕倍率
 @return 色圖
 */
+ (UIImage* _Nullable)ib_CreateImageWithColor:(UIColor* _Nullable)color
                             toSize:(CGSize)rectsize
                              Scale:(BOOL)scale;

#pragma mark - UIColor類

/// 隨機顏色
+ (UIColor * _Nullable)ib_RainbowColor:(ColorType)type;


/// 隨機取色
/// @param alpha 透明度
+ (UIColor * _Nullable)ib_RainbowColor:(ColorType)type Alpha:(CGFloat)alpha;

+ (UIColor * _Nullable)ib_HSBRainbowColor:(ColorType)type Alpha:(CGFloat)alpha;

+ (UIColor * _Nullable)ib_GoldenRatioColorWithAlpha:(CGFloat)alpha;

/// 十六進位值轉換UIColor
/// @param hexString 十六進位值
+ (UIColor * _Nullable)ib_ColorFromHexString:(NSString * _Nullable)hexString;

/// Image變成Color
/// @param imageName imageName description
/// @param rectsize rectsize description
+ (UIColor * _Nullable)ib_ColorWithPatternImage:(NSString * _Nullable)imageName
                               toSize:(CGSize)rectsize;

/// 互補色
/// @param color 原色
+ (UIColor * _Nullable)ib_ComplementaryColor:(UIColor * _Nullable)color;

/// 互補色
/// @param color 原色
/// @param alpha 透明度
+ (UIColor * _Nullable)ib_ComplementaryColor:(UIColor * _Nullable)color Alpha:(CGFloat)alpha;

#pragma mark - 文字類
#pragma mark ＊＊判斷字符串是否符合規則＊＊
/**
 *  使用正則表達式判斷字串
 *
 *  @param str   檢查字串
 *  @param regex 正則表達式
 *
 *  @return      否符合正則表達式規則
 */
+ (BOOL)ib_CheckingString:(NSString * _Nullable)str
                Predicate:(NSString * _Nullable)regex;

/**
 *  判斷字符串是否只包含字母
 *
 *  @param str 檢查字串
 *
 *  @return    是否只是包含字母
 */
+ (BOOL)ib_IsOnlyLetters:(NSString* _Nullable)str;

/**
 *  判斷字符串是否只包含數字
 *
 *  @param str 檢查字串
 *
 *  @return    是否只包含数字
 */
+ (BOOL)ib_IsOnlyNumbers:(NSString* _Nullable)str;

/**
 *  判斷字符串是否只包含字母和數字
 *
 *  @param str 檢查字串
 *
 *  @return    是否只包含字母和数字
 */
+ (BOOL)ib_IsOnlyAlphaNumeric:(NSString* _Nullable)str;

/**
 *  判斷是否為E-mail格式
 *
 *  @param email E-mail
 *
 *  @return 是否為E-mail格式
 */
+ (BOOL)ib_IsEmail:(NSString * _Nullable)email;

/**
 判斷是否含有表情

 @param string 檢查字串
 @return 是否含有表情
 */
+ (BOOL)ib_IsEmoji:(NSString * _Nullable)string;

/**
 檢查全部空白

 @param string 檢查字串
 @return 檢查全部空白
 */
+ (BOOL)ib_CheckSingleBlank:(NSString * _Nullable)string;

/// 檢查是否含有自訂字元
/// @param string 檢查字串
/// @param regex 自訂字元
+ (BOOL)ib_CheckString:(NSString * _Nullable)string Predicate:(NSString * _Nullable)regex;

#pragma mark ＊＊文字中空格及回車去掉＊＊
/**
 去除DeviceToken的“ ”,“<”,“>”
 
 @param devTokenDescription DeviceToken原形
 @return DeviceToken
 */
+ (NSString * _Nullable)ib_GetDeviceToken:(NSString * _Nullable)devTokenDescription;

/**
 *  將所有的空格及回車字符串去掉
 *
 *  @param str 處理字串
 *
 *  @return    無空格及回車的字串
 */
+ (NSString * _Nullable)ib_RemoveSpaceAndNewlineForALL:(NSString * _Nullable)str;

/**
 *  去掉字符串兩端的空格及回車
 *
 *  @param str 處理字串
 *
 *  @return 兩端無空格及回車的字串
 */
+ (NSString * _Nullable)ib_RemoveSpaceAndNewline:(NSString * _Nullable)str;

#pragma mark - 時間類
/**
 *  將日期NSString轉換成NSDate
 *
 *  @param str    日期NSString
 *  @param format 日期格式
 *
 *  @return 日期NSDate
 */
+ (NSDate * _Nullable)ib_DateNSStringToNSDate:(NSString * _Nullable)str withFormat:(NSString * _Nullable)format;

/**
 *  將日期NSDate轉換成NSString
 *
 *  @param date   日期NSDate
 *  @param format 日期格式
 *
 *  @return 日期NSString
 */
+ (NSString * _Nullable)ib_DateNSDateToNSString:(NSDate * _Nullable)date withFormat:(NSString * _Nullable)format;

/**
 *  取純日期格式NSDate（@"yyyy-MM-dd"）
 *
 *  @param date NSDate
 *
 *  @return 純日期格式NSDate
 */
+ (NSDate* _Nullable)ib_ShortDate:(NSDate* _Nullable)date;

/**
*  取純日期格式NSDate
*
*  @param date NSDate
*  @param format 日期格式
*
*  @return 純日期格式NSDate
*/
+ (NSDate* _Nullable)ib_ShortDate:(NSDate* _Nullable)date withFormat:(NSString * _Nullable)format;

/**
 *  建立時間戳記(提早一小時):2016-03-29T14:57:42+08:00
 *
 *  @return 時間戳記:2016-03-29T14:57:42+08:00
 */
+ (NSString * _Nullable)ib_GetTimeStampOfNow;

/**
 *  建立時間戳記(提早一小時):timeIntervalSince1970
 *
 *  @return 時間戳記:timeIntervalSince1970
 */
+ (NSString * _Nullable)ib_GetTimeStampOfUnix;

/**
 *  當前時間，自訂回傳格式 format: @"yyyy-MM-dd HH:mm:ss"、@"yyyy年MM月dd日 HH时mm分ss秒"
 *
 *  @param format 回傳時間格式：@"yyyy-MM-dd HH:mm:ss"
 *
 *  @return 自訂格式的當前時間
 */
+ (NSString * _Nullable)ib_CurrentDateWithFormat:(NSString * _Nullable)format;

/**
 *  檢查是否越期：
 *
 *  @param date   檢查日期
 *  @param format 日期格式
 *
 *  @return 是否越期：
 *      NSOrderedAscending:未過期;
 *      NSOrderedDescending:過期;
 *      NSOrderedSame:同一天;
 */
+ (NSComparisonResult)ib_CheckingDate:(NSString * _Nullable)date
                           withFormat:(NSString * _Nullable)format;

/**
 *  計算今天日期距離比對日期多久(Use NSString)，key回傳單位>>yy:年; MM:月; dd:日; HH:時; mm:分; ss:秒;
 *
 *  @param lastTime 比對日期
 *  @param format   比對日期格式
 *  @param key      key回傳單位
 *
 *  @return 計算今天日期距離比對日期多久，回傳依key值
 */
+ (NSNumber * _Nullable)ib_TodayFromLastTime:(NSString * _Nullable)lastTime
                    lastTimeFormat:(NSString * _Nullable)format
                           withKey:(NSString * _Nullable)key;

/**
 *  計算上次日期距離比對日期多久(Use NSString)，key回傳單位>>yy:年; MM:月; dd:日; HH:時; mm:分; ss:秒;
 *
 *  @param lastTime    上次日期
 *  @param format1     上次日期格式
 *  @param currentTime 比對日期
 *  @param format2     比對日期格式
 *  @param key         key回傳單位
 *
 *  @return 上次日期距離比對日期多久，回傳依key值
 */
+ (NSNumber * _Nullable)ib_TimeIntervalFromLastTime:(NSString * _Nullable)lastTime
                           lastTimeFormat:(NSString * _Nullable)format1
                            ToCurrentTime:(NSString * _Nullable)currentTime
                        currentTimeFormat:(NSString * _Nullable)format2
                                  withKey:(NSString * _Nullable)key;

/**
 *  計算上次日期距離比對日期多久(Use NSDate)，key回傳單位>>yy:年; MM:月; dd:日; HH:時; mm:分; ss:秒;
 *
 *  @param lastTime    上次日期
 *  @param currentTime 比對日期
 *  @param key         key回傳單位
 *
 *  @return 上次日期距離比對日期多久，回傳依key值
 */
+ (NSNumber * _Nullable)ib_TimeIntervalFromLastTime:(NSDate * _Nullable)lastTime
                            ToCurrentTime:(NSDate * _Nullable)currentTime
                                  withKey:(NSString * _Nullable)key;

/**
 *  計算兩個時間之間的間隔(Use NSString)
 *
 *  @param startTime    開始日期
 *  @param format1      開始日期格式
 *  @param endTime      結束日期
 *  @param format2      結束日期格式
 */
+ (NSDateComponents * _Nullable)ib_PleaseInsertStarTime:(NSString * _Nullable)startTime
                              startTimeFormat:(NSString * _Nullable)format1
                                      endTime:(NSString * _Nullable)endTime
                                endTimeFormat:(NSString * _Nullable)format2;

/**
 *  計算兩個時間之間的間隔(Use NSDate)
 *
 *  @param startTime    開始日期
 *  @param endTime      結束日期
 */
+ (NSDateComponents * _Nullable)ib_PleaseInsertStarTime:(NSDate * _Nullable)startTime
                                      endTime:(NSDate * _Nullable)endTime;


/**
 *  依據比對時間返回相對應日期格式(Use NSString)
 *
 *  @param timeString 比對日期
 *  @param format     比對日期格式
 *
 *  @return 依據比對時間返回相對應日期格式
 */
+ (NSString* _Nullable)ib_LocalizedShortDateStringWithNSString:(NSString * _Nullable)timeString
                                          withFormat:(NSString * _Nullable)format;

/**
 *  依據比對時間返回相對應日期格式(Use NSDate)
 *
 *  @param date 比對日期
 *
 *  @return 依據比對時間返回相對應日期格式
 */
+ (NSString* _Nullable)ib_LocalizedShortDateStringWithNSDate:(NSDate* _Nullable)date;

#pragma mark - Button類
/**
 建立Button，inBar:YES(UIBarButtonItem);NO:(UIButton)

 @param inBar YES(UIBarButtonItem);NO:(UIButton)
 @param title Button名稱
 @param titleColor Button名稱顏色
 @param backgroundColor Button顏色
 @param size Button大小
 @param tag tag
 @param target target
 @param action 動作
 @return Button
 */
+ (id _Nullable)ib_CreateButtoninitWithBar:(BOOL)inBar
                           Title:(NSString * _Nullable)title
                      TitleColor:(UIColor * _Nullable)titleColor
                 BackgroundColor:(UIColor * _Nullable)backgroundColor
                            Size:(CGSize)size
                             Tag:(NSInteger)tag
                          Target:(id _Nullable)target
                          Action:(SEL _Nullable)action;

/**
 使用圖片建立Button，inBar:YES(UIBarButtonItem);NO:(UIButton)
 
 @param inBar YES(UIBarButtonItem);NO:(UIButton)
 @param title Button名稱
 @param color Button名稱顏色
 @param normalImage NormalImage
 @param highlightedImage HighlightedImage
 @param target target
 @param action 動作
 @return Button
 */
+ (id _Nullable)ib_CreateButtoninitWithBar:(BOOL)inBar
                           Title:(NSString * _Nullable)title
                      TitleColor:(UIColor * _Nullable)color
             ImageFileNameNormal:(UIImage * _Nullable)normalImage
        ImageFileNameHighlighted:(UIImage * _Nullable)highlightedImage
                             Tag:(NSInteger)tag
                          Target:(id _Nullable)target
                          Action:(SEL _Nullable)action;

/**
 Selected Button（勾選型Button）
 
 @param title Button名稱
 @param color Button名稱顏色
 @param tag tag
 @param normalImage normalImage
 @param SelectedImage SelectedImage
 @param target target
 @param action 動作
 @return 勾選Button
 */
+ (UIButton * _Nullable)ib_CreateSelectedButtonTitle:(NSString * _Nullable)title
                                TitleColor:(UIColor * _Nullable)color
                                       Tag:(NSInteger)tag
                       ImageFileNameNormal:(UIImage * _Nullable)normalImage
                     ImageFileNameSelected:(UIImage * _Nullable)SelectedImage
                                    Target:(id _Nullable)target
                                    Action:(SEL _Nullable)action;

/**
 Icon Button（上圖下文型Button）
 
 @param title Title
 @param color TitleColor
 @param tag tag
 @param normalImage normalImage
 @param highlightedImage highlightedImage
 @param target target
 @param action 動作
 @return Icon Button
 */
+ (UIButton * _Nullable)ib_CreateIconButtonTitle:(NSString * _Nullable)title
                            TitleColor:(UIColor * _Nullable)color
                                   Tag:(NSInteger)tag
                   ImageFileNameNormal:(UIImage * _Nullable)normalImage
              ImageFileNameHighlighted:(UIImage * _Nullable)highlightedImage
                                Target:(id _Nullable)target
                                Action:(SEL _Nullable)action;

/**
 *  建立NavigationItem<可以調整BarButtonItem位置>
 *
 *  @param width            偏移量
 *  @param tag              tag
 *  @param normalImage      NormalImage
 *  @param highlightedImage HighlightedImage
 *  @param target      target
 *  @param action      動作
 *
 *  @return BarButtonItems
 */
+ (NSMutableArray * _Nullable)ib_SetBarButtonItemsOffset:(float)width
                                           Tag:(NSInteger)tag
                           ImageFileNameNormal:(UIImage * _Nullable)normalImage
                      ImageFileNameHighlighted:(UIImage * _Nullable)highlightedImage
                                        Target:(id _Nullable)target
                                        Action:(SEL _Nullable)action;

#pragma mark -NSString

/// <#Description#>
/// @param text <#text description#>
/// @param size <#size description#>
/// @param font <#font description#>
+ (CGRect)ib_GetRect:(NSString * _Nullable)text MAXSize:(CGSize)size Font:(UIFont * _Nullable)font;

/**
*  計算行數numberOfLines
*  @param text 文字內容
*  @param size 文字容器大小
*  @param font 文字字型資訊
*/
+ (NSInteger)ib_GetNumberOfLines:(NSString * _Nullable)text MAXSize:(CGSize)size Font:(UIFont * _Nullable)font;

#pragma mark - AlertCntroller
/**
 建立AlertCntroller,按鈕返回btnIndex說明：CancelButton:0;DestructiveButton:1;OtherButton:2~;
 
 @param vc 父視窗
 @param type 提示窗形式（AlertView,ActionSheet）
 @param title title description
 @param message message description
 @param delay 無按鈕時，自動消失時間(默認時間：1.0)
 @param block 按鈕返回動作void (^)(NSInteger btnIndex)
 @param completion 結束後動作
 @param cancelBtnTitle cancelBtnTitle description
 @param destructiveBtnTitle destructiveBtnTitle description
 @param otherBtnTitles otherBtnTitles description
 */
+ (void)ib_ShowAlertCntrollerWithViewController:(id _Nonnull )vc
                           AlertControllerStyle:(UIAlertControllerStyle)type
                                          Title:(NSString * _Nullable)title
                                        Message:(NSString * _Nullable)message
                                     AfterDelay:(NSTimeInterval)delay
                                      CallBlock:(void (^ _Nullable)(NSInteger btnIndex))block
                                     Completion:(void (^ _Nullable)(void))completion
                              CancelButtonTitle:(NSString * _Nullable)cancelBtnTitle
                         DestructiveButtonTitle:(NSString * _Nullable)destructiveBtnTitle
                              OtherButtonTitles:(NSString * _Nullable)otherBtnTitles, ...;

/**
 簡易提示窗：type 提示窗形式（0:UIAlertControllerStyleActionSheet 1:UIAlertControllerStyleAlert）無按鈕時delay自動消失時間：(1.0 ~)
 
 @param vc 父視窗
 @param type 提示窗形式（AlertView,ActionSheet）
 @param title title description
 @param message message description
 @param cancelBtnTitle cancelBtnTitle description
 @param destructiveBtnTitle destructiveBtnTitle description
 @param delay 無按鈕時，自動消失時間(默認時間：1.0)
 @param block CancelButton:0,DestructiveButton:1
 @param completion 結束後動作
 */
+ (void)ib_ShowMessageViewWith:(id _Nonnull)vc
                          Type:(UIAlertControllerStyle)type
                         Title:(NSString * _Nullable)title
                       Message:(NSString * _Nullable)message
             CancelButtonTitle:(NSString * _Nullable)cancelBtnTitle
        DestructiveButtonTitle:(NSString * _Nullable)destructiveBtnTitle
                    AfterDelay:(NSTimeInterval)delay
                     CallBlock:(void (^ _Nullable)(NSInteger btnIndex))block
                    Completion:(void (^ _Nullable)(void))completion;

/**
 有輸入匡的警告視窗
 
 @param vc 父視窗
 @param type 提示窗形式（AlertView,ActionSheet）
 @param configurationHandler 鍵盤設定
 @param title title description
 @param message message description
 @param cancelBtnTitle cancelBtnTitle description
 @param destructiveBtnTitle destructiveBtnTitle description
 @param block CancelButton:@"",DestructiveButton:textField.text
 @param completion 結束後動作
 */
+ (void)ib_ShowMessageViewWithTextField:(id _Nonnull )vc
                                   Type:(UIAlertControllerStyle)type
      TextFieldWithConfigurationHandler:(void (^ __nullable)(UITextField * _Nullable textField))configurationHandler
                                  Title:(NSString *_Nullable)title
                                Message:(NSString *_Nullable)message
                      CancelButtonTitle:(NSString *_Nullable)cancelBtnTitle
                 DestructiveButtonTitle:(NSString *_Nullable)destructiveBtnTitle
                              CallBlock:(void (^_Nullable)(NSString * _Nonnull str))block
                             Completion:(void (^_Nonnull)(void))completion;

#pragma mark - ViewController
/**
 獲取當前ViewController
 方法出處：XHTeng/XHCryptorTools https://github.com/gitkong/NSObject-UIViewController
 @return 當前ViewController
 */
+ (UIViewController * _Nullable)ib_GetViewController;

/**
 UIStoryboard建立UIViewController

 @param storyName UIStoryboardName
 @param identifier identifier
 @return return UIViewController
 */
+ (id _Nullable)ib_GetControllerWithStoryboardName:(NSString * _Nullable)storyName Identifier:(NSString * _Nullable)identifier;

#pragma mark 打開SFSafariViewController
/// 打開SFSafariViewController
/// @param URLString 網址
/// @param completion completion
+ (void)ib_PushSFSafariViewController:(NSString * _Nullable)URLString completion:(void (^ __nullable)(void))completion;

#pragma mark 返回上一頁
/**
 返回上一頁
 */
+ (void)ib_BackPreviouPageView;

#pragma mark 跳轉系統頁面
/**
 跳轉系統頁面
 */
+ (void)ib_goGeneral;

#pragma mark - app内部直接评分
/**
 app内部直接评分
 */
+ (void)showAppStoreScore;

#pragma mark - 分享工具UIActivityViewController
/**
 分享工具UIActivityViewController

 @param activityItems 分享內容
 @param block 成功與否
 */
+ (void)ib_ShareWithSourceView:(id _Nonnull )vc ActivityItems:(NSArray *_Nullable)activityItems CallBlock:(void (^_Nonnull)(BOOL completed))block;


@end
