//
//  CloudViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by willy.wu on 2019/10/9.
//  Copyright © 2019 WiFi@MBP. All rights reserved.
//

#import "CloudViewController.h"

#define Client_id @"BkbnHiURrKvnFCzAJndMt21Cd25nSiYI"
#define Client_secret @"HnQTBcdCSef4puv2vn3I3RxMms1wh65C"
#define Redirect_uri @"com.CustomURLAPP.demo"

@interface CloudViewController ()

@property (nonatomic, strong) MicroLifeCloud2GManager *cloudManager;

@end

@implementation CloudViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self.sdk cancelScan];
    kWeakSelf(self)
    [[NSNotificationCenter defaultCenter] addObserverForName:@"CloudViewController" object:nil queue:[NSOperationQueue mainQueue] usingBlock:^(NSNotification * _Nonnull note) {
        [weakself getAuthorizationCode:note.object];
    }];
}

- (MicroLifeCloud2GManager *)cloudManager {
    MicroLifeCloud2GManager *cloudManager = [MicroLifeCloud2GManager shareWhithSeverType:MicroLifeProductUSASever ID:Client_id Secret:Client_id RedirectURL:Redirect_uri showLog:YES];
    return cloudManager;
}

- (IBAction)loginAction:(id)sender {
    [self.cloudManager loginWithVC:self animated:YES completion:^{
        
    }];
}
 
- (IBAction)postAPIAction:(id)sender {
    switch ([sender tag]) {
        case 100:
            [self getMemberData];
            break;
        case 101:
            [self getBPMHistory];
            break;
        case 102:
            [self uploadCSV];
            break;
        default:
            break;
    }
}

- (void)getAuthorizationCode:(NSString *)code {
    kWeakSelf(self)
    [self dismissViewControllerAnimated:YES completion:nil];
    [self.cloudManager postOAuthToken:authorization_code code:code redirectURI:Redirect_uri FinishBlock:^(bool success, NSInteger code, MicroLifeCloudDataModel * _Nullable dataModel, NSError * _Nullable error) {
        NSString *log = [NSString stringWithFormat:@"getAuthorizationCode:%@",dataModel.parseDictionary];
        [weakself addLogWhitText:log];
    }];
}

- (void)getMemberData {
    kWeakSelf(self)
    [self.cloudManager getMemberData:^(bool success, NSInteger code, MicroLifeCloudDataModel * _Nullable dataModel, NSError * _Nullable error) {
        NSString *log = [NSString stringWithFormat:@"getMemberData:%@",dataModel.value];
        [weakself addLogWhitText:log];
    }];
}

- (void)getBPMHistory {
    kWeakSelf(self)
    [self.cloudManager getHistoryDataWhithType:CloudDataTypeBPM Start:@"" End:@"" limit:0 offset:0 timeType:CloudDataTimeModifyDate automatic:YES FinishBlock:^(bool success, NSInteger code, bool fulfill, MicroLifeCloudDataModel * _Nonnull dataModel, NSError * _Nullable error) {
        NSString *log = [NSString stringWithFormat:@"getBPMHistory:%@",dataModel.value];
        [weakself addLogWhitText:log];
    }];
}

- (void)uploadCSV {
    kWeakSelf(self)
    NSData *csv = [NSData dataWithContentsOfURL:[NSURL fileURLWithPath:[[NSBundle mainBundle] pathForResource:@"3gup" ofType:@"csv"]]];
    [self.cloudManager uploadCSV:csv FinishBlock:^(bool success, NSInteger code, MicroLifeCloudDataModel * _Nullable dataModel, NSError * _Nullable error) {
        NSString *log = [NSString stringWithFormat:@"\ncode:%ld\ninfo:%@\nuploadCSV:%@ ",dataModel.code,dataModel.info,dataModel.value];
        [weakself addLogWhitText:log];
    }];
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
