//
//  ECGViewController.h
//  MicroLifeDeviceSDK-Demo
//
//  Created by willy.wu on 2021/8/25.
//  Copyright © 2021 WiFi@MBP. All rights reserved.
//

#import "RootViewController.h"

#define  SCREENWIDTH ([UIScreen mainScreen].bounds.size.width)
#define  SCREENHEIGHT ([UIScreen mainScreen].bounds.size.height)
#define DDLeftPadding   15

typedef NS_ENUM(NSInteger, ECGDataType) {
    ECGDataTypeRAW,
    ECGDataTypeLowPassFilter,
    ECGDataTypeBandPassFilter,
    ECGDataTypeMovingAvgFilter,
    ECGDataTypeLPBPMovingAvgFilter, // default
};

NS_ASSUME_NONNULL_BEGIN

@interface ECGViewController : RootViewController

@property (nonatomic, retain) NSMutableArray *dataArray;
@property (nonatomic, retain) NSMutableArray *beatArray;
@property (nonatomic, retain) NSMutableArray *orderArray;
@property (nonatomic, retain) NSMutableArray *lengthSource;

@property (nonatomic, assign) CGRect frameZero;

@property (weak, nonatomic) IBOutlet UIScrollView *scrollView;

@property (weak, nonatomic) IBOutlet UIScrollView *ECGView;

@property (retain, nonatomic) YOECGChartView *ecg;

@property (nonatomic, strong) NSNumber *BPM;

@property (nonatomic, assign) BOOL LDOFF;

@property (nonatomic, assign) BOOL showECG;

@property (nonatomic, assign) ECGDataType showECGDataType;

@property (weak, nonatomic) IBOutlet UIButton *Firfilter;

@property (nonatomic, strong) MicroLifeECGSettingValues *settingValue;
@property (nonatomic, strong) MicroLifeECGFunctionSettingValues *functionSettingValues;

@property (weak, nonatomic) IBOutlet UITextField *historyMeasuremeNumber;

@property (weak, nonatomic) IBOutlet UISwitch *SWBT;

@property (weak, nonatomic) IBOutlet UISwitch *SWBPplusECG;

@property (weak, nonatomic) IBOutlet UISwitch *SWmax3003filter;

@property (weak, nonatomic) IBOutlet UISwitch *SWTurnOffLeaddetect;

@property (weak, nonatomic) IBOutlet UISwitch *SWcontinuedECG;

@property (weak, nonatomic) IBOutlet UISwitch *SWBeepOn;

@property (weak, nonatomic) IBOutlet UISwitch *SWAfibOn;

@property (weak, nonatomic) IBOutlet UITextField *MAMInterval;

@property (weak, nonatomic) IBOutlet UITextField *length;

@property (weak, nonatomic) IBOutlet UITextField *MAMrest;

@property (nonatomic, assign) NSInteger ECGDatas;



@end

NS_ASSUME_NONNULL_END
