//
//  MenuInfo.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by 吳憲有 on 2022/12/8.
//  Copyright © 2022 WiFi@MBP. All rights reserved.
//

#import "MenuInfo.h"

@implementation MenuInfo

- (instancetype)init {
    self = [super init];
    if (self) {
        [self removalInfo];
    }
    return self;
}

- (void)removalInfo {
    self.backgroundColor = [IdeabusToolBox ib_RainbowColor:ColorGolden];
    self.textColor = [IdeabusToolBox ib_ComplementaryColor:self.backgroundColor Alpha:1.0];
    self.device = nil;
    self.name = nil;
}

- (void)addDevice:(MicroLifeDevice *)device {
    self.device = device;
    self.name = device.name;
    self.UUID = device.UUID;
    self.RSSI = device.RSSI;
    self.mac = device.mac;
    self.bt_code = device.bt_code;
}

+ (NSMutableArray *)menus {
    MenuInfo *menuInfo1 = [MenuInfo new];
    menuInfo1.title = @"Scan Device";
    menuInfo1.deviceType = 100;
    MenuInfo *menuInfo2 = [MenuInfo new];
    menuInfo2.title = @"Cloud API";
    menuInfo2.deviceType = 101;
    MenuInfo *menuInfo3 = [MenuInfo new];
    menuInfo3.title = @"SEND SUPPORT EMAIL";
    menuInfo3.deviceType = 102;
    MenuInfo *menuInfo4 = [MenuInfo new];
    menuInfo4.title = @"3G BP";
    menuInfo4.deviceType = DeviceType3GBP;
    MenuInfo *menuInfo5 = [MenuInfo new];
    menuInfo5.title = @"4G BP";
    menuInfo5.deviceType = DeviceType4GBP;
    MenuInfo *menuInfo6 = [MenuInfo new];
    menuInfo6.title = @"Weight";
    menuInfo6.deviceType = DeviceTypeWeight;
    MenuInfo *menuInfo7 = [MenuInfo new];
    menuInfo7.title = @"Temperature";
    menuInfo7.deviceType = DeviceTypeTemperature;
    MenuInfo *menuInfo8 = [MenuInfo new];
    menuInfo8.title = @"Oxygen";
    menuInfo8.deviceType = DeviceTypeOxygen;
    MenuInfo *menuInfo9 = [MenuInfo new];
    menuInfo9.title = @"WatchBP Home";
    menuInfo9.deviceType = DeviceTypeWatchBPHome;
    MenuInfo *menuInfo10 = [MenuInfo new];
    menuInfo10.title = @"WatchBP O3";
    menuInfo10.deviceType = DeviceTypeWatchBPO3;
    MenuInfo *menuInfo11 = [MenuInfo new];
    menuInfo11.title = @"WatchBP Office";
    menuInfo11.deviceType = DeviceTypeWatchBPOffice;
    MenuInfo *menuInfo12 = [MenuInfo new];
    menuInfo12.title = @"WatchBP M1";
    menuInfo12.deviceType = DeviceTypeWatchBPM1;
    MenuInfo *menuInfo13 = [MenuInfo new];
    menuInfo13.title = @"Blood Sugar 700";
    menuInfo13.deviceType = DeviceTypeBGM700;
    MenuInfo *menuInfo17 = [MenuInfo new];
    menuInfo17.title = @"Blood Sugar 800";
    menuInfo17.deviceType = DeviceTypeBGM800;
    MenuInfo *menuInfo14 = [MenuInfo new];
    menuInfo14.title = @"Peakflow Meter";
    menuInfo14.deviceType = DeviceTypePFM;
    MenuInfo *menuInfo15 = [MenuInfo new];
    menuInfo15.title = @"Electrocardiography";
    menuInfo15.deviceType = DeviceTypeECG;
    MenuInfo *menuInfoNFC = [MenuInfo new];
    menuInfoNFC.title = @"NFC";
    menuInfoNFC.deviceType = 103;
    MenuInfo *menuInfo16 = [MenuInfo new];
    menuInfo16.title = @"5G BP";
    menuInfo16.deviceType = DeviceType5GBP;
    NSMutableArray *menus = [NSMutableArray arrayWithObjects:menuInfo1, menuInfo2, menuInfo3, menuInfo4, menuInfo5, menuInfo16, menuInfo6, menuInfo7, menuInfo8, menuInfo9, menuInfo10, menuInfo11, menuInfo12, menuInfo13, menuInfo17, menuInfo14, menuInfo15, nil];
    return menus;
}

@end
