//
//  MenuViewController.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by 吳憲有 on 2022/12/8.
//  Copyright © 2022 WiFi@MBP. All rights reserved.
//

#import "MenuViewController.h"
#import <CoreNFC/CoreNFC.h>

@implementation MenuViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.menuTableView.backgroundColor = [UIColor whiteColor];
    self.menuTableView.refreshControl = self.menuRefresh;
    [self BLESDK];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self loadData];
}

- (void)BLESDK {
    kWeakSelf(self)
    [self.sdk cancelAllConnect];
    self.bp3g = [MicroLife3GBP shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.bp3g autoConnect:NO];
    self.bp4g = [MicroLife4GBP shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.bp4g autoConnect:NO];
    self.bp5g = [MicroLife5GBP shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.bp5g autoConnect:NO];
    self.temperature = [MicroLifeTemperature shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.temperature autoConnect:NO];
    self.oxygen = [MicroLifeOxygen shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.oxygen autoConnect:NO];
    self.weight = [MicroLifeWS500 shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.weight autoConnect:NO];
    [self.weight addDeviceModel:@[@"Best Core BLE"]];
    self.bgm800 = [MicroLifeBGM800 shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.bgm800 autoConnect:NO];
    self.bgm700 = [MicroLifeBGM700 shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.bgm700 autoConnect:NO];
    self.watchBPOffice = [MicroLifeWatchBPOffice shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.watchBPOffice autoConnect:NO];
    self.watchBPOfficeVascular = [MicroLifeWatchBPOfficeVascular shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.watchBPOfficeVascular autoConnect:NO];
    self.watchBPM1 = [MicroLifeWatchBPM1 shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.watchBPM1 autoConnect:NO];
    self.watchBPHome = [MicroLifeWatchBPHome shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.watchBPHome autoConnect:NO];
    self.watchBPO3 = [MicroLifeWatchBPO3 shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.watchBPO3 autoConnect:NO];
    self.peakFlowMeter = [MicroLifePFM shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.peakFlowMeter autoConnect:NO];
    self.electrocardiography = [MicroLifeECG shareWhithAuthorization:SDK_code Key:SDK_key Secret:SDK_secret];
    [self.electrocardiography autoConnect:NO];
    NSMutableArray *devices = [NSMutableArray array];
    if (self.bp3g) {
        [devices addObject:self.bp3g];
    }
    if (self.bp4g) {
        [devices addObject:self.bp4g];
    }
    if (self.bp5g) {
        [devices addObject:self.bp5g];
    }
    if (self.temperature) {
        [devices addObject:self.temperature];
    }
    if (self.oxygen) {
        [devices addObject:self.oxygen];
    }
    if (self.weight) {
        [devices addObject:self.weight];
    }
    if (self.bgm800) {
        [devices addObject:self.bgm800];
    }
    if (self.bgm700) {
        [devices addObject:self.bgm700];
    }
    if (self.watchBPOffice) {
        [devices addObject:self.watchBPOffice];
    }
    if (self.watchBPM1) {
        [devices addObject:self.watchBPM1];
    }
    if (self.watchBPOfficeVascular) {
        [devices addObject:self.watchBPOfficeVascular];
    }
    if (self.watchBPHome) {
        [devices addObject:self.watchBPHome];
    }
    if (self.watchBPO3) {
        [devices addObject:self.watchBPO3];
    }
    if (self.peakFlowMeter) {
        [devices addObject:self.peakFlowMeter];
    }
    if (self.electrocardiography) {
        [devices addObject:self.electrocardiography];
    }
    [self.sdk device:devices];
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        if ([device isKindOfClass:[MicroLifeDevice class]]) {
            [weakself addDevice:device];
        }
    } CancelScanBlock:^() {
        
    }];
}

- (void)addDevice:(MicroLifeDevice *)device {
    for (MenuInfo *m in self.menus) {
        if (m.deviceType == device.deviceType) {
            [m addDevice:device];
        }
    }
    kWeakSelf(self)
    dispatch_async(dispatch_get_main_queue(), ^{
        [weakself.menuTableView reloadData];
    });
}

#pragma mark - RefreshControl
- (UIRefreshControl *)menuRefresh {
    if (!_menuRefresh) {
        self.menuRefresh = [UIRefreshControl new];
        [self.menuRefresh addTarget:self action:@selector(loadData) forControlEvents:UIControlEventValueChanged];
    }
    return _menuRefresh;
}

- (void)loadData {
    for (MenuInfo *m in self.menus) {
        [m removalInfo];
    }
    kWeakSelf(self)
    dispatch_async(dispatch_get_main_queue(), ^{
        [weakself.menuTableView reloadData];
    });
    [self.sdk cancelScan];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        // stop refreshing after 1 seconds
        [weakself.sdk startScan];
        [weakself.menuRefresh endRefreshing];
     });
}

#pragma mark -
- (NSMutableArray *)menus {
    if (!_menus) {
        self.menus = [MenuInfo menus];
    }
    return _menus;
}

#pragma mark - UITableViewDelegate,UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.menus.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 100;
}
    
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Cell"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"Cell"];
    }
    MenuInfo *info = [self.menus objectAtIndex:indexPath.row];
    if (info.name) {
        cell.textLabel.text = [NSString stringWithFormat:@"%@\nName:%@ bt_code:%ld RSSI:%@\nUUID:%@\nMac:%@",
                               info.title,
                               info.name,
                               info.bt_code,
                               info.RSSI,
                               info.UUID,
                               info.mac];
    } else {
        cell.textLabel.text = info.title;
    }
    cell.textLabel.numberOfLines = 4;
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    cell.textLabel.adjustsFontSizeToFitWidth = YES;
    cell.backgroundColor = info.backgroundColor;
    cell.textLabel.textColor = info.textColor;
    return cell;
}
    
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    MenuInfo *info = [self.menus objectAtIndex:indexPath.row];
    switch (info.deviceType) {
        case 100:
            [self presentVC:@"OneViewController" Info:info];
            break;
        case 101:
            [self presentVC:@"CloudViewController" Info:info];
            break;
        case 102:
            if ([MFMailComposeViewController canSendMail]) {
                [self emailLog];
            } else {
                [self shareLog];
            }
            break;
        case 103:
            [self presentVC:@"ScanNFCViewController" Info:info];
            break;
        case DeviceType3GBP:
        case DeviceType4GBP:
        case DeviceType5GBP:
            [self presentVC:@"BPMViewController" Info:info];
            break;
        case DeviceTypeWeight:
            [self presentVC:@"WEIViewController" Info:info];
            break;
        case DeviceTypeTemperature:
            [self presentVC:@"TEMPViewController" Info:info];
            break;
        case DeviceTypeOxygen:
            [self presentVC:@"OxygenViewController" Info:info];
            break;
        case DeviceTypeECG:
            [self presentVC:@"ECGViewController" Info:info];
            break;
        case DeviceTypeBGM700:
        case DeviceTypeBGM800:
            [self presentVC:@"BSViewController" Info:info];
            break;
        case DeviceTypeWatchBPHome:
            [self presentVC:@"WBPViewController" Info:info];
            break;
        case DeviceTypeWatchBPO3:
            [self presentVC:@"WBO3ViewController" Info:info];
            break;
        case DeviceTypeWatchBPM1:
            [self presentVC:@"M1ViewController" Info:info];
            break;
        case DeviceTypeWatchBPOffice:
        case DeviceTypeWatchBPOfficeVascular:
            [self presentVC:@"WBOViewController" Info:info];
            break;
        case DeviceTypePFM:
            [self presentVC:@"PFMViewController" Info:info];
            break;
        case DeviceTypePPG:
            [self presentVC:@"PPGViewController" Info:info];
            break;
        default:
            break;
    }
}

- (void)presentVC:(NSString *)identifier Info:(MenuInfo *)info {
//    if ([identifier isEqualToString:@"ScanNFCViewController"]) {
//        info.title = @"NFC";
//        self.menuInfo = info;
//        [self ReadAllData];
//    } else {
//        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
//        RootViewController *vc = [storyboard instantiateViewControllerWithIdentifier:identifier];
//        vc.menuInfo = info;
//        [self.navigationController pushViewController:vc animated:YES];
//    }
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    RootViewController *vc = [storyboard instantiateViewControllerWithIdentifier:identifier];
    vc.menuInfo = info;
    [self.navigationController pushViewController:vc animated:YES];
}




@end

