//
//  RootViewController.h
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/21.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>
#import <MessageUI/MessageUI.h>
#import "NSObject+ModelToDictionary.h"
#import "UIView+PFInputViewControl.h"
#import "UIScreen+DDSizeTransfrom.h"
#import "NSDecimalNumber+DDExtension.h"
#import "AxcDrawPathTool.h"
#import "spoDrawView.h"
#import "YOECGChartView.h"
#import "IdeabusPickView.h"
#import "IdeabusToolBox.h"

#import "MenuInfo.h"

#warning Please enter the corresponding SDK Key
#define SDKkey_BPM @""
#define SDKkey_WEI @""
#define SDKkey_BT @""
#define SDKkey_SPO2 @""
#define SDKkey_WBP @""
#define SDKkey_BS @""
#define SDKkey_PF @""
#define SDKkey_ECG @""
#define SDKkey_PPG @""

#define SDK_code @""
#define SDK_key @""
#define SDK_secret @""

//强弱引用
#define kWeakSelf(type)  __weak typeof(type) weak##type = type;
#define kStrongSelf(type) __strong typeof(type) type = weak##type;

//Log
#define kMicroLifeDeviceSDKLog(module, fmt,...) [[LogManager sharedInstance]logInfo:module logStr:fmt,##__VA_ARGS__];

typedef void(^changedBlock) (id item);

@interface RootViewController : UIViewController


@property (weak, nonatomic) IBOutlet UITextView *logView;

@property (weak, nonatomic) IBOutlet UILabel *MicroLifeDeviceSDKVersionNumber;

@property (weak, nonatomic) IBOutlet UILabel *VersionNumber;

@property (retain, nonatomic) MicroLifeUserInfo *currUser;

@property (nonatomic, strong) BLESDK *sdk;
@property (nonatomic, strong) MicroLife3GBP *bp3g;
@property (nonatomic, strong) MicroLife4GBP *bp4g;
@property (nonatomic, strong) MicroLife5GBP *bp5g;
@property (nonatomic, strong) MicroLifeWS500 *weight;
@property (nonatomic, strong) MicroLifeTemperature *temperature;
@property (nonatomic, strong) MicroLifeOxygen *oxygen;
@property (nonatomic, strong) MicroLifeECG *electrocardiography;
@property (nonatomic, strong) MicroLifeWatchBPHome *watchBPHome;
@property (nonatomic, strong) MicroLifeWatchBPO3 *watchBPO3;
@property (nonatomic, strong) MicroLifeWatchBPOffice *watchBPOffice;
@property (nonatomic, strong) MicroLifeWatchBPM1 *watchBPM1;
@property (nonatomic, strong) MicroLifeBGM800 *bgm800;//？？
@property (nonatomic, strong) MicroLifeBGM700 *bgm700;
@property (nonatomic, strong) MicroLifePFM *peakFlowMeter;
@property (nonatomic, strong) MicroLifePPG *ppg;
@property (nonatomic, strong) MicroLifeWatchBPOfficeVascular *watchBPOfficeVascular;

@property (nonatomic, strong) MenuInfo *menuInfo;

@property (nonatomic, strong) NSNumber *currentUserNumber;

@property (nonatomic, strong) id currDeviceInfo;

@property (nonatomic, strong) NSDate *lastWork;

@property (nonatomic, strong) NSString *fileName;
@property (nonatomic, strong) NSString *filePath;

@property (nonatomic, strong) NSString *rowName;
@property (nonatomic, strong) NSString *rowPath;

- (void)clearLogStr;

- (void)addLogWhitText:(NSString *)text;

- (void)file:(NSString *)name;

- (void)writeData:(id)stringData;
- (void)writeRowData:(id)stringData;

- (NSString *)date;

- (NSString *)getBPMuserID;

- (NSString *)getEBodyuserID;

- (NSInteger)getAge;

- (void)setupKeyboardShowHide;

- (void)shareWithActivityItems:(NSArray *)activityItems CallBlock:(void (^)(BOOL completed))block;

- (void)showHIinfPressurePickView:(NSString *)selectedItem ConfirmBlock:(confirmBlock)confirmBlock CancelBlock:(cancelBlock)cancelBlock HideBlock:(hideBlock)hideBlock;

- (void)showIntervalPickView:(NSString *)selectedItem ConfirmBlock:(confirmBlock)confirmBlock CancelBlock:(cancelBlock)cancelBlock HideBlock:(hideBlock)hideBlock;

#pragma mark - DataResponseDelegate
- (void)connectDeviceInfo:(id)device PeripheralState:(CBPeripheralState)state;
- (void)log:(id)device CMD:(NSInteger)CMD Model:(id)model Error:(NSError *)error;

- (void)shareLog;
- (void)emailLog;

#pragma mark - NSUserDefaults存取類
/**
 *  將變量存至NSUserDefaults
 *
 *  @param value 儲存變量
 *  @param key   儲存變量名
 */
- (void)saveNSUserDefaults:(id)value Key:(NSString *)key;

/**
 *  從NSUserDefaults讀取變量
 *
 *  @param key 讀取變量名
 *
 *  @return 讀取變量
 */
- (id)readNSUserDefaults:(NSString *)key;
@end
