//
//  WBO3ViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by willy.wu on 2019/11/1.
//  Copyright © 2019 WiFi@MBP. All rights reserved.
//

#import "WBO3ViewController.h"

@implementation WBO3ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
//    // stop Auto Scan
//    [self.sdk autoScan:NO];
    [self connectWatchBPO3];
    // Bluetooth scanner join device
    [self.sdk device:@[self.watchBPO3]];
    // Bluetooth status of mobile phone
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    // Scanning device response
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
//        [weakself.watchBPO3 connectDevice];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
    }];
    // Device connection status response
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        weakself.settingValue = nil;
        weakself.setting2g.hidden = weakself.setting5g.hidden = YES;
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*5);
}

#pragma mark - device
- (void)connectWatchBPO3 {
    kWeakSelf(self)
    // Device manager 
    self.watchBPO3 = [MicroLifeWatchBPO3 shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPO3 addDeviceModel:@[@"WatchBP O3"]];
    // stop Auto Scan
//    [self.watchBPO3 autoScan:NO];
    // Auto Connect [Default:Open]
//    [self.watchBPO3 setAutoConnect:NO];
    // Device response
    [self.watchBPO3 getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.watchBPO3 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPO3 CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPO3ReadCBPData:
            case CMDWatchBPO3ReadDeviceInfo:
            case CMDWatchBPO3ReadDeviceTime:
            case CMDWatchBPO3ReadSerialNumber:
            case CMDWatchBPO3ReadBTModuleName:
            case CMDWatchBPO3ClearAllHistorys:
            case CMDWatchBPO3WriteUser:
            case CMDWatchBPO3WriteSettingValues:
            case CMDWatchBPO35SWriteSettingValues:
            case CMDWatchBPO3ReadFunctionSettingValue:
            case CMDWatchBPO3WriteDeviceTime:
                break;
            case CMDWatchBPO3ReadSettingValues:
            case CMDWatchBPO35SReadSettingValues:
                [weakself WBO3BLEManagerResponseReadSettingValue:model];
                break;
            case CMDWatchBPO3ReadHistorys:
                [weakself WBO3BLEManagerResponseReadAllHistorys:model];
                break;
            case CMDWatchBPO3ReadUserAndVersionData: {
                MicroLifeUserInfo *userInfo = [model valueForKey:@"UserInfo"];
                weakself.editUserID.text = userInfo.bpmUserID;
            }
                break;
            default:
                break;
        }
    }];
}

- (void)WBO3BLEManagerResponseReadAllHistorys:(nonnull MicroLifeWatchBPDRecord *)data {
    if ([data isKindOfClass:[MicroLifeWatchBPDRecord class]]) {
        self.editCBPindex.text = data.historyMeasurementNumber.stringValue;
    }
}

- (void)WBO3BLEManagerResponseReadSettingValue:(nonnull MicroLifeWatchBPSettingValues *)settingValue {
    self.settingValue = settingValue;
    if (settingValue.settingValues) {
        self.setting2g.hidden = YES;
        self.setting5g.hidden = NO;
        self.editHI_infPressure5G.text = [NSString stringWithFormat:@"%ld",settingValue.HI_infPressure];
        self.SW_checkhide5G.on = settingValue.SW_checkhide.boolValue;
        if (settingValue.settingValues.count >= 1) {
            MicroLifeWatchBPSettingValues *sv1 = settingValue.settingValues[0];
            self.editP1Start.text = [NSString stringWithFormat:@"%@",sv1.ABPMStart];
            self.editP1End.text = [NSString stringWithFormat:@"%@",sv1.ABPMEnd];
            self.editP1Interval.text = [NSString stringWithFormat:@"%ld",sv1.Interval];
            self.SW_P1_silent.on = sv1.SW_SEL_silent.boolValue;
            self.SW_BP_P1_meas_off.on = sv1.BP_meas_off.boolValue;
            self.SW_CBP_P1_meas_off.on = sv1.CBP_meas_off.boolValue;
        }
        if (settingValue.settingValues.count >= 2) {
            MicroLifeWatchBPSettingValues *sv2 = settingValue.settingValues[1];
            self.editP2Start.text = [NSString stringWithFormat:@"%@",sv2.ABPMStart];
            self.editP2End.text = [NSString stringWithFormat:@"%@",sv2.ABPMEnd];
            self.editP2Interval.text = [NSString stringWithFormat:@"%ld",sv2.Interval];
            self.SW_P2_silent.on = sv2.SW_SEL_silent.boolValue;
            self.SW_BP_P2_meas_off.on = sv2.BP_meas_off.boolValue;
            self.SW_CBP_P2_meas_off.on = sv2.CBP_meas_off.boolValue;
        }
        if (settingValue.settingValues.count >= 3) {
            MicroLifeWatchBPSettingValues *sv3 = settingValue.settingValues[2];
            self.editP3Start.text = [NSString stringWithFormat:@"%@",sv3.ABPMStart];
            self.editP3End.text = [NSString stringWithFormat:@"%@",sv3.ABPMEnd];
            self.editP3Interval.text = [NSString stringWithFormat:@"%ld",sv3.Interval];
            self.SW_P3_silent.on = sv3.SW_SEL_silent.boolValue;
            self.SW_BP_P3_meas_off.on = sv3.BP_meas_off.boolValue;
            self.SW_CBP_P3_meas_off.on = sv3.CBP_meas_off.boolValue;
        }
        if (settingValue.settingValues.count >= 4) {
            MicroLifeWatchBPSettingValues *sv4 = settingValue.settingValues[3];
            self.editP4Start.text = [NSString stringWithFormat:@"%@",sv4.ABPMStart];
            self.editP4End.text = [NSString stringWithFormat:@"%@",sv4.ABPMEnd];
            self.editP4Interval.text = [NSString stringWithFormat:@"%ld",sv4.Interval];
            self.SW_P4_silent.on = sv4.SW_SEL_silent.boolValue;
            self.SW_BP_P4_meas_off.on = sv4.BP_meas_off.boolValue;
            self.SW_CBP_P4_meas_off.on = sv4.CBP_meas_off.boolValue;
        }
        if (settingValue.settingValues.count >= 5) {
            MicroLifeWatchBPSettingValues *sv5 = settingValue.settingValues[4];
            self.editP5Start.text = [NSString stringWithFormat:@"%@",sv5.ABPMStart];
            self.editP5End.text = [NSString stringWithFormat:@"%@",sv5.ABPMEnd];
            self.editP5Interval.text = [NSString stringWithFormat:@"%ld",sv5.Interval];
            self.SW_P5_silent.on = sv5.SW_SEL_silent.boolValue;
            self.SW_BP_P5_meas_off.on = sv5.BP_meas_off.boolValue;
            self.SW_CBP_P5_meas_off.on = sv5.CBP_meas_off.boolValue;
        }
    } else {
        self.setting2g.hidden = NO;
        self.setting5g.hidden = YES;
        self.editABPMStart.text = [NSString stringWithFormat:@"%@",settingValue.ABPMStart];
        self.editABPMEnd.text = [NSString stringWithFormat:@"%@",settingValue.ABPMEnd];
        self.editABPMInt_1.text = [NSString stringWithFormat:@"%ld",settingValue.ABPMInt_first];
        self.editABPMInt_2.text = [NSString stringWithFormat:@"%ld",settingValue.ABPMInt_second];
        self.editHI_infPressure2G.text = [NSString stringWithFormat:@"%ld",settingValue.HI_infPressure];
        self.SW_checkhide2G.on = settingValue.SW_checkhide.boolValue;
        self.SW_silent2G.on = settingValue.SW_SEL_silent.boolValue;
        self.CBP_zone1_meas_off2G.on = settingValue.CBP_zone1_meas_off.boolValue;
        self.CBP_zone2_meas_off2G.on = settingValue.CBP_zone2_meas_off.boolValue;
        self.editCBPInt_1.text = [NSString stringWithFormat:@"%ld",settingValue.CBPInt_first];
        self.editCBPInt_2.text = [NSString stringWithFormat:@"%ld",settingValue.CBPInt_second];
    }
}

- (void)writeSettingValue:(id)sender {
    if (self.settingValue.settingValues) {
        switch ([sender tag]) {
            case 100:
                self.settingValue.SW_checkhide = @(((UISwitch *)sender).on);
                break;
            case 200:
                self.settingValue.HI_infPressure = ((UITextField *)sender).text.integerValue;
                break;
            default:
                break;
        }
        MicroLifeWatchBPSettingValues *sv = self.settingValue.settingValues[([sender tag]/100)-1];
        switch ([sender tag]%100) {
            case 1:
                sv.SW_SEL_silent = @(((UISwitch *)sender).on);
                break;
            case 2:
                sv.BP_meas_off = @(((UISwitch *)sender).on);
                break;
            case 3:
                sv.CBP_meas_off = @(((UISwitch *)sender).on);
                break;
            case 4:
                sv.ABPMStart = @(((UITextField *)sender).text.integerValue);
                break;
            case 5:
                sv.ABPMEnd = @(((UITextField *)sender).text.integerValue);
                break;
            case 6:
                sv.Interval = ((UITextField *)sender).text.integerValue;
                break;
            default:
                break;
        }
    } else {
        switch ([sender tag]) {
            case 100:
                self.settingValue.SW_checkhide = @(((UISwitch *)sender).on);
                break;
            case 101:
                self.settingValue.SW_SEL_silent = @(((UISwitch *)sender).on);
                break;
            case 102:
                self.settingValue.CBP_zone1_meas_off = @(((UISwitch *)sender).on);
                break;
            case 103:
                self.settingValue.CBP_zone2_meas_off = @(((UISwitch *)sender).on);
                break;
            case 200:
                self.settingValue.HI_infPressure = ((UITextField *)sender).text.integerValue;
                break;
            case 104:
                self.settingValue.ABPMStart = @(((UITextField *)sender).text.integerValue);
                break;
            case 105:
                self.settingValue.ABPMEnd = @(((UITextField *)sender).text.integerValue);
                break;
            case 204:
                self.settingValue.ABPMInt_first = ((UITextField *)sender).text.integerValue;
                break;
            case 205:
                self.settingValue.ABPMInt_second = ((UITextField *)sender).text.integerValue;
                break;
            case 304:
                self.settingValue.CBPInt_first = ((UITextField *)sender).text.integerValue;
                break;
            case 305:
                self.settingValue.CBPInt_second = ((UITextField *)sender).text.integerValue;
                break;
            default:
                break;
        }
    }
}

#pragma mark - selected info
- (IBAction)editCBPRaw:(UISegmentedControl *)sender {
    NSString *format = @"No CBP Raw";
    switch (sender.selectedSegmentIndex) {
        case 0:
            self.dformat = MicroLifeDNoCBPRaw;
            format = @"No CBP Raw";
            break;
        case 1:
            self.dformat = MicroLifeDLowCBPRaw;
            format = @"Low CBP Raw";
            break;
        case 2:
            self.dformat = MicroLifeDFullCBPRaw;
            format = @"Full CBP Raw";
            break;
        default:
            break;
    }
    NSString *log = [NSString stringWithFormat:@"Selected CBPRaw:%@",format];
    [self addLogWhitText:log];
}

- (IBAction)switchSettingValues:(UISwitch *)sender {
    NSString *log = [NSString stringWithFormat:@"Switch SettingValues:"];
    switch ([sender tag]%100) {
        case 0:
            log = [log stringByAppendingFormat:@"SW_checkhide"];
            break;
        case 1:
            log = [log stringByAppendingFormat:@"SW_SEL_silent"];
            break;
        case 2:
            log = [log stringByAppendingFormat:@"BP_meas_off"];
            [self lock:sender];
            break;
        case 3:
            log = [log stringByAppendingFormat:@"CBP_meas_off"];
            break;
        default:
            break;
    }
    log = [log stringByAppendingFormat:@" %@",sender.on?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self writeSettingValue:sender];
}

- (void)lock:(UISwitch *)sender {
    if (self.settingValue.settingValues) {
        switch ([sender tag]) {
            case 102:
                self.editP1Start.enabled = self.editP1End.enabled = self.editP1Interval.enabled = self.SW_P1_silent.enabled = self.SW_CBP_P1_meas_off.enabled = sender.on;
                break;
            case 202:
                self.editP2Start.enabled = self.editP2End.enabled = self.editP2Interval.enabled = self.SW_P2_silent.enabled = self.SW_CBP_P2_meas_off.enabled = sender.on;
                break;
            case 302:
                self.editP3Start.enabled = self.editP3End.enabled = self.editP3Interval.enabled = self.SW_P3_silent.enabled = self.SW_CBP_P3_meas_off.enabled = sender.on;
                break;
            case 402:
                self.editP4Start.enabled = self.editP4End.enabled = self.editP4Interval.enabled = self.SW_P4_silent.enabled = self.SW_CBP_P4_meas_off.enabled = sender.on;
                break;
            case 502:
                self.editP5Start.enabled = self.editP5End.enabled = self.editP5Interval.enabled = self.SW_P5_silent.enabled = self.SW_CBP_P5_meas_off.enabled = sender.on;
                break;
            default:
                break;
        }
    }
}

- (IBAction)editSettingValues:(UITextField *)sender {
    NSString *log = [NSString stringWithFormat:@"Edit SettingValues:"];
    switch ([sender tag]%100) {
        case 4:
            log = [log stringByAppendingFormat:@"Start Hour %@",sender.text];
            break;
        case 5:
            log = [log stringByAppendingFormat:@"End Hour %@",sender.text];
            break;
        case 6:
            log = [log stringByAppendingFormat:@"Interval %@",sender.text];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
    [self writeSettingValue:sender];
}

- (IBAction)editHIinfPressure:(UITextField *)sender {
    [self.view endEditing:YES];
    [self showHIinfPressurePickView:sender.text ConfirmBlock:^(id item) {
        sender.text = item;
        [self writeSettingValue:sender];
    } CancelBlock:^(id item) {
        sender.text = item;
        [self writeSettingValue:sender];
    } HideBlock:^{
        
    }];
}

- (IBAction)editInterval:(UITextField *)sender {
    [self.view endEditing:YES];
    [self showIntervalPickView:sender.text ConfirmBlock:^(id item) {
        sender.text = item;
        [self writeSettingValue:sender];
    } CancelBlock:^(id item) {
        sender.text = item;
        [self writeSettingValue:sender];
    } HideBlock:^{
        
    }];
}

#pragma mark - IBAction
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    switch (sender.tag) {
        case 100:
            [self.watchBPO3 readAllHistorys];
            break;
        case 101:
            if (self.editCBPindex.text.integerValue > 0) {
                [self.watchBPO3 readCBPDataWithIndex:self.editCBPindex.text.integerValue Dformat:self.dformat];
            }
            break;
        case 103:
            [self.watchBPO3 clearAllHistorys];
            break;
        case 104:
            [self.watchBPO3 disconnect];
            break;
        case 105:
            [self.watchBPO3 readUserAndVersionData];
            break;
        case 106:
            [self.watchBPO3 writeUserID:self.editUserID.text];
            break;
        case 107:
            [self.watchBPO3 readSettingValues];
            break;
        case 108:
            if (self.settingValue) {
                if (self.settingValue.settingValues) {
                    BOOL checkSettingValues = [self.settingValue checkSettingValues] && [self checkSettingValues];
                    NSString *log = [NSString stringWithFormat:@"checkSettingValues:%@",checkSettingValues?@"YES":@"NO"];
                    [self addLogWhitText:log];
                    if (checkSettingValues) {
                        checkSettingValues = [self.watchBPO3 writeSettingValuesWithSettingValues:self.settingValue.settingValues HI_infPressure:self.settingValue.HI_infPressure SW_checkhide:self.settingValue.SW_checkhide.boolValue];
                        NSString *log = [NSString stringWithFormat:@"writeSettingValues:%@",checkSettingValues?@"YES":@"NO"];
                        [self addLogWhitText:log];
                    }
                } else {
                    BOOL checkSettingValues = [self.settingValue checkSettingValues];
                    NSString *log = [NSString stringWithFormat:@"checkSettingValues:%@",checkSettingValues?@"YES":@"NO"];
                    [self addLogWhitText:log];
                    if (checkSettingValues) {
                        checkSettingValues = [self.watchBPO3 writeSettingValuesWithSelectedABPMStart:self.settingValue.ABPMStart.integerValue ABPMEnd:self.settingValue.ABPMEnd.integerValue ABPMInt_first:self.settingValue.ABPMInt_first ABPMInt_second:self.settingValue.ABPMInt_second HI_infPressure:self.settingValue.HI_infPressure SW_checkhide:self.settingValue.SW_checkhide.boolValue SW_SEL_silent:self.settingValue.SW_SEL_silent.boolValue CBP_zone1_meas_off:self.settingValue.CBP_zone1_meas_off.boolValue CBP_zone2_meas_off:self.settingValue.CBP_zone2_meas_off.boolValue CBPInt_first:self.settingValue.CBPInt_first CBPInt_second:self.settingValue.CBPInt_second];
                        NSString *log = [NSString stringWithFormat:@"writeSettingValues:%@",checkSettingValues?@"YES":@"NO"];
                        [self addLogWhitText:log];
                    }
                }
            } else {
                [self addLogWhitText:@"Please, readSettingValues ​​first"];
            }
            break;
        case 111:
            [self.watchBPO3 readDeviceIDAndInfo];
            break;
        case 112:
            [self.watchBPO3 readDeviceTime];
            break;
        case 113:
            [self.watchBPO3 writeDeviceTime];
            break;
        case 114:
            [self.watchBPO3 readSerialNumber];
            break;
        case 116:
            [self.watchBPO3 readFunctionSettingValue];
            break;
        case 119:
            [self.watchBPO3 readBTModuleName];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}

- (BOOL)checkSettingValues {
    BOOL checkSettingValues = YES;
    BOOL check1 = YES;
    BOOL check2 = YES;
    BOOL check3 = YES;
    BOOL check4 = YES;
    MicroLifeWatchBPSettingValues *sv1;
    MicroLifeWatchBPSettingValues *sv2;
    MicroLifeWatchBPSettingValues *sv3;
    MicroLifeWatchBPSettingValues *sv4;
    MicroLifeWatchBPSettingValues *sv5;
    if (self.settingValue.settingValues) {
        if (self.settingValue.settingValues.count >= 1) {
            sv1 = self.settingValue.settingValues[0];
        }
        if (self.settingValue.settingValues.count >= 2) {
            sv2 = self.settingValue.settingValues[1];
        }
        if (self.settingValue.settingValues.count >= 3) {
            sv3 = self.settingValue.settingValues[2];
        }
        if (self.settingValue.settingValues.count >= 4) {
            sv4 = self.settingValue.settingValues[3];
        }
        if (self.settingValue.settingValues.count >= 5) {
            sv5 = self.settingValue.settingValues[4];
        }
        if (sv1.BP_meas_off.boolValue & sv2.BP_meas_off.boolValue) {
            check1 = (sv1.ABPMEnd.integerValue <= sv2.ABPMStart.integerValue);
        }
        if (sv2.BP_meas_off.boolValue & sv3.BP_meas_off.boolValue) {
            check2 = (sv2.ABPMEnd.integerValue <= sv3.ABPMStart.integerValue);
        }
        if (sv3.BP_meas_off.boolValue & sv4.BP_meas_off.boolValue) {
            check3 = (sv3.ABPMEnd.integerValue <= sv4.ABPMStart.integerValue);
        }
        if (sv4.BP_meas_off.boolValue & sv5.BP_meas_off.boolValue) {
            check4 = (sv4.ABPMEnd.integerValue <= sv5.ABPMStart.integerValue);
        }
        checkSettingValues = check1 & check2 & check3 & check4;
    }
    return checkSettingValues;
}

@end
