//
//  WBOViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by willy.wu on 2019/10/2.
//  Copyright © 2019 WiFi@MBP. All rights reserved.
//

#import "WBOViewController.h"

@implementation WBOViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
    switch (self.menuInfo.deviceType) {
        case DeviceTypeWatchBPM1:
            [self connectWatchBPOfficeLTC];
            [self.sdk device:@[self.watchBPM1]];
            break;
        case DeviceTypeWatchBPOffice:
            [self connectWatchBPOffice];
            [self.sdk device:@[self.watchBPOffice]];
            break;
        case DeviceTypeWatchBPOfficeVascular:
            [self connectWatchBPOfficeVascular];
            [self.sdk device:@[self.watchBPOfficeVascular]];
            break;
        default:
            break;
    }
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
   
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*5);
}

#pragma mark - device
- (void)connectWatchBPOffice {
    kWeakSelf(self)
    self.watchBPOffice = [MicroLifeWatchBPOffice shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPOffice getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.watchBPOffice getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPOffice CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPOfficeReadHistorys:
                [weakself WBOBLEManagerResponseReadAllHistorys:model];
                break;
            case CMDWatchBPOfficeReadUserAndVersionData: {
                MicroLifeUserInfo *userInfo = [model valueForKey:@"UserInfo"];
                weakself.editUserID.text = userInfo.bpmUserID;
            }
                break;
            case CMDWatchBPOfficeReadSettingValues:
                [weakself WBOBLEManagerResponseReadSettingValue:model];
                break;
            case CMDWatchBPOfficeReadCBPData:
            case CMDWatchBPOfficeReadDeviceInfo:
            case CMDWatchBPOfficeReadDeviceTime:
            case CMDWatchBPOfficeReadBTModuleName:
            case CMDWatchBPOfficeClearAllHistorys:
            case CMDWatchBPOfficeWriteUser:
            case CMDWatchBPOfficeWriteSettingValues:
            case CMDWatchBPOfficeWriteDeviceTime:
            case CMDWatchBPOfficeReadFunctionSettingValue:
            case CMDWatchBPOfficeStartRemoteMeasurement:
            case CMDWatchBPOfficeStopRemoteMeasurement:
            case CMDWatchBPOfficeSendRemoteMeasurementStatusEvery5seconds:
            case CMDWatchBPOfficeSendMeasurementResultsForEachMeasurement:
                break;
            default:
                break;
        }
    }];
}

- (void)connectWatchBPOfficeLTC {
    kWeakSelf(self)
    self.watchBPM1 = [MicroLifeWatchBPM1 shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPM1 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPM1 CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPM1ReadHistorys:
                [weakself WBOBLEManagerResponseReadAllHistorys:model];
                break;
            case CMDWatchBPM1ReadUserAndVersionData: {
                MicroLifeUserInfo *userInfo = [model valueForKey:@"UserInfo"];
                weakself.editUserID.text = userInfo.bpmUserID;
            }
                break;
            case CMDWatchBPM1ReadSettingValues:
                [weakself WBOBLEManagerResponseReadSettingValue:model];
                break;
            case CMDWatchBPM1ReadDeviceInfo:
            case CMDWatchBPM1ReadDeviceTime:
            case CMDWatchBPM1ReadBTModuleName:
            case CMDWatchBPM1ClearAllHistorys:
            case CMDWatchBPM1WriteUser:
            case CMDWatchBPM1WriteSettingValues:
            case CMDWatchBPM1WriteDeviceTime:
            case CMDWatchBPM1ReadFunctionSettingValue:
                break;
            default:
                break;
        }
    }];
}

- (void)connectWatchBPOfficeVascular {
    kWeakSelf(self)
    self.watchBPOfficeVascular = [MicroLifeWatchBPOfficeVascular shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPOfficeVascular getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.watchBPOfficeVascular getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPOfficeVascular CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPOfficeVascularReadHistorys:
                [weakself WBOBLEManagerResponseReadAllHistorys:model];
                break;
            case CMDWatchBPOfficeVascularReadUserAndVersionData: {
                MicroLifeUserInfo *userInfo = [model valueForKey:@"UserInfo"];
                weakself.editUserID.text = userInfo.bpmUserID;
            }
                break;
            case CMDWatchBPOfficeVascularReadSettingValues:
                [weakself WBOBLEManagerResponseReadSettingValue:model];
                break;
            case CMDWatchBPOfficeVascularReadCBPAndPWVData:
            case CMDWatchBPOfficeVascularReadDeviceInfo:
            case CMDWatchBPOfficeVascularReadDeviceTime:
            case CMDWatchBPOfficeVascularReadBTModuleName:
            case CMDWatchBPOfficeVascularClearAllHistorys:
            case CMDWatchBPOfficeVascularWriteUser:
            case CMDWatchBPOfficeVascularWriteSettingValues:
            case CMDWatchBPOfficeVascularWriteDeviceTime:
            case CMDWatchBPOfficeVascularReadFunctionSettingValue:
            case CMDWatchBPOfficeVascularStartRemoteMeasurement:
            case CMDWatchBPOfficeVascularStopRemoteMeasurement:
            case CMDWatchBPOfficeVascularSendRemoteMeasurementStatusEvery5seconds:
                break;
            default:
                break;
        }
    }];
}

- (void)WBOBLEManagerResponseReadAllHistorys:(nonnull MicroLifeWatchBPDRecord *)data {
    if ([data isKindOfClass:[MicroLifeWatchBPDRecord class]]) {
        self.editCBPindex.text = data.historyMeasurementNumber.stringValue;
    }
}

- (void)WBOBLEManagerResponseReadSettingValue:(nonnull MicroLifeWatchBPSettingValues *)settingValues {
    self.editAUS_HI_infPressure.text = [NSString stringWithFormat:@"%ld",settingValues.AUS_HI_infPressure];
    self.editHI_infPressure.text = [NSString stringWithFormat:@"%ld",settingValues.HI_infPressure];
    self.SW_AUTO_hide.on = settingValues.SW_AUTO_hide.boolValue;
    self.SW_SEL_silent.on = settingValues.SW_SEL_silent.boolValue;
    self.SW_AUS_Hide.on = settingValues.SW_AUS_Hide.boolValue;
    self.SW_AVG_no_include_first.on = settingValues.SW_AVG_no_include_first.boolValue;
    self.SW_CBP.on = settingValues.SW_CBP.boolValue;
    self.SW_AFib.on = settingValues.SW_AFib.boolValue;
    self.SW_AMPM.on = settingValues.SW_AMPM.boolValue;
    self.SW_Kpa.on = settingValues.SW_Kpa.boolValue;
    self.editRestTime.text = [NSString stringWithFormat:@"%@",settingValues.RestTime];
    self.editIntervalTime.text = [NSString stringWithFormat:@"%@",settingValues.IntervalTime];
    self.editAutoMeasureNumber.text = [NSString stringWithFormat:@"%@",settingValues.AutoMeasureNumber];
}

#pragma mark - selected info
- (IBAction)editCBPRaw:(UISegmentedControl *)sender {
    NSString *format = @"No CBP Raw";
    switch (sender.selectedSegmentIndex) {
        case 0:
            self.dformat = MicroLifeDNoCBPRaw;
            format = @"No CBP Raw";
            break;
        case 1:
            self.dformat = MicroLifeDLowCBPRaw;
            format = @"Low CBP Raw";
            break;
        case 2:
            self.dformat = MicroLifeDFullCBPRaw;
            format = @"Full CBP Raw";
            break;
        default:
            break;
    }
    NSString *log = [NSString stringWithFormat:@"selectedCBPRaw:%@",format];
    [self addLogWhitText:log];
}

- (IBAction)editSettingValues:(UISwitch *)sender {
    NSString *log = [NSString stringWithFormat:@"editSettingValues:"];
    switch ([sender tag]) {
        case 200:
            log = [log stringByAppendingFormat:@"SW_AUTO_hide"];
            break;
        case 201:
            log = [log stringByAppendingFormat:@"SW_SEL_silent"];
            break;
        case 202:
            log = [log stringByAppendingFormat:@"SW_AUS_Hide"];
            break;
        case 203:
            log = [log stringByAppendingFormat:@"SW_AVG_no_include_first"];
            break;
        case 204:
            log = [log stringByAppendingFormat:@"SW_CBP"];
            break;
        case 205:
            log = [log stringByAppendingFormat:@"SW_AFib"];
            break;
        case 206:
            log = [log stringByAppendingFormat:@"SW_AMPM"];
            break;
        case 207:
            log = [log stringByAppendingFormat:@"SW_Kpa"];
            break;
        default:
            break;
    }
    log = [log stringByAppendingFormat:@" %@",sender.on?@"YES":@"NO"];
    [self addLogWhitText:log];
}

- (IBAction)editHIinfPressure:(UITextField *)sender {
    [self.view endEditing:YES];
    [self showHIinfPressurePickView:sender.text ConfirmBlock:^(id item) {
        sender.text = item;
    } CancelBlock:^(id item) {
        sender.text = item;
    } HideBlock:^{
        
    }];
}


#pragma mark - IBAction
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    switch (self.menuInfo.deviceType) {
        case DeviceTypeWatchBPM1:
            [self watchBPM1Action:[sender tag]];
            break;
        case DeviceTypeWatchBPOffice:
            [self watchBPOfficeAction:[sender tag]];
            break;
        case DeviceTypeWatchBPOfficeVascular:
            [self watchBPOfficeVascularAction:[sender tag]];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}

- (void)watchBPM1Action:(NSInteger)tag {
    switch (tag) {
        case 100:
            [self.watchBPM1 readAllHistorys];
            break;
        case 103:
            [self.watchBPM1 clearAllHistorys];
            break;
        case 104:
            [self.watchBPM1 disconnect];
            break;
        case 105:
            [self.watchBPM1 readUserAndVersionData];
            break;
        case 106:
            [self.watchBPM1 writeUserID:self.editUserID.text];
            break;
        case 107:
            [self.watchBPM1 readSettingValues];
            break;
        case 108:
            [self.watchBPM1 writeSettingValuesWithSelectedAUS_HI_infPressure:self.editAUS_HI_infPressure.text.integerValue HI_infPressure:self.editHI_infPressure.text.integerValue SW_AUTO_hide:self.SW_AUTO_hide.on SW_SEL_silent:self.SW_SEL_silent.on SW_AUS_Hide:self.SW_AUS_Hide.on SW_AVG_no_include_first:self.SW_AVG_no_include_first.on SW_CBP:self.SW_CBP.on SW_AFib:self.SW_AFib.on SW_AMPM:self.SW_AMPM.on SW_Kpa:self.SW_Kpa.on RestTime:self.editRestTime.text.integerValue IntervalTime:self.editIntervalTime.text.integerValue AutoMeasureNumber:self.editAutoMeasureNumber.text.integerValue];
            break;
        case 111:
            [self.watchBPM1 readDeviceIDAndInfo];
            break;
        case 112:
            [self.watchBPM1 readDeviceTime];
            break;
        case 113:
            [self.watchBPM1 writeDeviceTime];
            break;
        case 116:
            [self.watchBPM1 readFunctionSettingValue];
            break;
        case 119:
            [self.watchBPM1 readBTModuleName];
            break;
        case 124:
            [self.watchBPM1 readSerialNumber];
            break;
        default:
            break;
    }
}

- (void)watchBPOfficeAction:(NSInteger)tag {
    switch (tag) {
        case 100:
            [self.watchBPOffice readAllHistorys];
            break;
        case 101:
            if (self.editCBPindex.text.integerValue > 0) {
                [self.watchBPOffice readCBPDataWithIndex:self.editCBPindex.text.integerValue Dformat:self.dformat];
            }
            break;
        case 103:
            [self.watchBPOffice clearAllHistorys];
            break;
        case 104:
            [self.watchBPOffice disconnect];
            break;
        case 105:
            [self.watchBPOffice readUserAndVersionData];
            break;
        case 106:
            [self.watchBPOffice writeUserID:self.editUserID.text];
            break;
        case 107:
            [self.watchBPOffice readSettingValues];
            break;
        case 108:
            [self.watchBPOffice writeSettingValuesWithSelectedAUS_HI_infPressure:self.editAUS_HI_infPressure.text.integerValue HI_infPressure:self.editHI_infPressure.text.integerValue SW_AUTO_hide:self.SW_AUTO_hide.on SW_SEL_silent:self.SW_SEL_silent.on SW_AUS_Hide:self.SW_AUS_Hide.on SW_AVG_no_include_first:self.SW_AVG_no_include_first.on SW_CBP:self.SW_CBP.on SW_AFib:self.SW_AFib.on SW_AMPM:self.SW_AMPM.on SW_Kpa:self.SW_Kpa.on RestTime:self.editRestTime.text.integerValue IntervalTime:self.editIntervalTime.text.integerValue AutoMeasureNumber:self.editAutoMeasureNumber.text.integerValue];
            break;
        case 111:
            [self.watchBPOffice readDeviceIDAndInfo];
            break;
        case 112:
            [self.watchBPOffice readDeviceTime];
            break;
        case 113:
            [self.watchBPOffice writeDeviceTime];
            break;
        case 116:
            [self.watchBPOffice readFunctionSettingValue];
            break;
        case 119:
            [self.watchBPOffice readBTModuleName];
            break;
        case 137:
            [self.watchBPOffice startRemoteMeasurementWhtihCBPFunction:self.dformat];
            break;
        case 138:
            [self.watchBPOffice stopRemoteMeasurement];
            break;
        default:
            break;
    }
}

- (void)watchBPOfficeVascularAction:(NSInteger)tag {
    switch (tag) {
        case 100:
            [self.watchBPOfficeVascular readAllHistorys];
            break;
        case 101:
            if (self.editCBPindex.text.integerValue > 0) {
                [self.watchBPOfficeVascular readCBPDataWithIndex:self.editCBPindex.text.integerValue Dformat:self.dformat];
            }
            break;
        case 103:
            [self.watchBPOfficeVascular clearAllHistorys];
            break;
        case 104:
            [self.watchBPOfficeVascular disconnect];
            break;
        case 105:
            [self.watchBPOfficeVascular readUserAndVersionData];
            break;
        case 106:
            [self.watchBPOfficeVascular writeUserID:self.editUserID.text];
            break;
        case 107:
            [self.watchBPOfficeVascular readSettingValues];
            break;
        case 108:
            [self.watchBPOfficeVascular writeSettingValuesWithSelectedAUS_HI_infPressure:self.editAUS_HI_infPressure.text.integerValue HI_infPressure:self.editHI_infPressure.text.integerValue SW_AUTO_hide:self.SW_AUTO_hide.on SW_SEL_silent:self.SW_SEL_silent.on SW_AUS_Hide:self.SW_AUS_Hide.on SW_AVG_no_include_first:self.SW_AVG_no_include_first.on SW_CBP:self.SW_CBP.on SW_AFib:self.SW_AFib.on SW_AMPM:self.SW_AMPM.on SW_Kpa:self.SW_Kpa.on RestTime:self.editRestTime.text.integerValue IntervalTime:self.editIntervalTime.text.integerValue AutoMeasureNumber:self.editAutoMeasureNumber.text.integerValue];
            break;
        case 111:
            [self.watchBPOfficeVascular readDeviceIDAndInfo];
            break;
        case 112:
            [self.watchBPOfficeVascular readDeviceTime];
            break;
        case 113:
            [self.watchBPOfficeVascular writeDeviceTime];
            break;
        case 116:
            [self.watchBPOfficeVascular readFunctionSettingValue];
            break;
        case 119:
            [self.watchBPOfficeVascular readBTModuleName];
            break;
        case 137:
            [self.watchBPOfficeVascular startRemoteMeasurementWhtihDeviceMode:MicroLifeDeviceModeLA CBPFunction:MicroLifeOVDNoCBPRaw];
            break;
        case 138:
            [self.watchBPOfficeVascular stopRemoteMeasurement];
            break;
        default:
            break;
    }
}

#pragma mark - DataResponseDelegate

@end
