//
//  WBPViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by willy.wu on 2019/4/15.
//  Copyright © 2019 WiFi@MBP. All rights reserved.
//

#import "WBPViewController.h"

@implementation WBPViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
    [self connectWatchBPHome];
    [self.sdk device:@[self.watchBPHome]];
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*5);
}

#pragma mark - device
- (void)connectWatchBPHome {
    kWeakSelf(self)
    self.watchBPHome = [MicroLifeWatchBPHome shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPHome getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.watchBPHome getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPHome CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPHomeReadUsualModeHistoryData:
            case CMDWatchBPHomeReadUsualModeHistoryDataIncludeEachMeasurement:
            {
                MicroLifeWatchBPDRecord *dRecord = model;
                NSString *log = [NSString stringWithFormat:@"dRecord historyMeasuremeNumber:%@ MData:%ld",dRecord.historyMeasurementNumber,dRecord.MData.count];
                [self addLogWhitText:log];
            }
                break;
            case CMDWatchBPHomeReadDiagnosticModeHistoryData:
            case CMDWatchBPHomeReadNocturnalModeSetting:
            case CMDWatchBPHomeReadDeviceInfo:
            case CMDWatchBPHomeReadDeviceTime:
            case CMDWatchBPHomeReadSerialNumber:
            case CMDWatchBPHomeReadUserAndVersionData:
            case CMDWatchBPHomeReadNocturnalModeHistoryData:
            case CMDWatchBPHomeClearHistoryDataMode:
            case CMDWatchBPHomeClearCurrentModeHistoryData:
            case CMDWatchBPHomeWriteDeviceTime:
            case CMDWatchBPHomeWriteUserID:
            case CMDWatchBPHomeChangeNocturnalMode:
            case CMDWatchBPHomeReadDeviceSettingOfMeasurement:
            case CMDWatchBPHomeWriteDeviceSettingOfMeasurement:
                break;
            default:
                break;
        }
    }];
}

#pragma mark - IBAction
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    switch (sender.tag) {
        case 100:
            [self.watchBPHome readUsualModeHistoryData];
            break;
        case 101:
            [self.watchBPHome readDiagnosticModeHistoryData];
            break;
        case 102:
        {
            BOOL usualMode = arc4random_uniform(2);
            BOOL diagnosticMode = arc4random_uniform(2);
            BOOL nocturnalMode = arc4random_uniform(2);
            [self.watchBPHome clearHistoryDataWithSelectedUsualMode:usualMode DiagnosticMode:diagnosticMode NocturnalMode:nocturnalMode];
            log = [log stringByAppendingFormat:@" Selected >> UsualMode:%@ DiagnosticMode:%@ NocturnalMode:%@",usualMode?@"YES":@"NO",diagnosticMode?@"YES":@"NO",nocturnalMode?@"YES":@"NO"];
        }
            break;
        case 103:
            [self.watchBPHome clearCurrentModeHistoryData];
            break;
        case 104:
            [self.watchBPHome disconnect];
            break;
        case 105:
            [self.watchBPHome writeDeviceTime];
            break;
        case 106:
        {
            NSString *ID = [self getBPMuserID];
            [self saveNSUserDefaults:ID Key:@"bpmUserID"];
            [self.watchBPHome writeUserID:ID];
            log = [log stringByAppendingFormat:@"：%@",ID];
        }
            break;
        case 107:
            [self.watchBPHome readNocturnalModeSetting];
            break;
        case 108:
        {
            BOOL changeNocturnalModeSetting = arc4random_uniform(2);
            NSDateComponents *dateComponents = [[NSCalendar currentCalendar] components:NSCalendarUnitYear | NSCalendarUnitMonth fromDate:[NSDate date]];
            NSInteger month = arc4random_uniform(dateComponents.month)+1;
            unsigned int dayMax = 31;
            switch (month) {
                case 2:
                    dayMax = 29;
                    break;
                case 4:case 6:case 10:case 12:
                    dayMax = 30;
                    break;
                default:
                    break;
            }
            NSInteger day = arc4random_uniform(dayMax)+1;
            NSArray *hours = @[@"0",@"1",@"2",@"3",@"4",@"5",@"6",@"22",@"23"];
            NSString *hour = [hours objectAtIndex:arc4random_uniform(hours.count)];
            [self.watchBPHome changeNocturnalModeSettingOn:changeNocturnalModeSetting StartYear:dateComponents.year StartMonth:month StartDay:day StartHour:hour.integerValue];
            log = [log stringByAppendingFormat:@" changeNocturnalModeSetting:%@ %ld/%ld/%ld %@ \nNote : This command requires matching hardware to set. You can use “readDeviceIDAndInfo(MicroLifeDeviceInfo.openNocturnalMode)” to check if the device supports it. ",changeNocturnalModeSetting?@"YES":@"NO",dateComponents.year,month,day,hour];
        }
            break;
        case 110:
            [self.watchBPHome readDeviceIDAndInfo];
            break;
        case 111:
            [self.watchBPHome readDeviceTime];
            break;
        case 112:
            [self.watchBPHome readUserAndVersionData];
            break;
        case 113:
            [self.watchBPHome readNocturnalModeHistoryData];
            break;
        case 114:
            [self.watchBPHome readSerialNumber];
            break;
        case 115:
        {
            NSInteger measurement = arc4random_uniform(2)+1;
            NSInteger restTime = arc4random_uniform(6);
            NSInteger intervalTime = arc4random_uniform(6);
            BOOL ecludeAverage = arc4random_uniform(10)%2;
            BOOL SWAfib = arc4random_uniform(10)%2;
            [self.watchBPHome writeDeviceSettingOfMeasurement:measurement RestTime:restTime IntervalTime:intervalTime ExcludeAverage:ecludeAverage SWAfib:SWAfib];
            log = [log stringByAppendingFormat:@" Selected >> measurement:%ld RestTime:%ld IntervalTime:%ld ExcludeAverage:%@ SWAfib:%@",measurement,restTime,intervalTime,ecludeAverage?@"YES":@"NO",SWAfib?@"YES":@"NO"];
        }
            break;
        case 116:
            [self.watchBPHome readDeviceSettingOfMeasurement];
            break;
        case 117:
            [self.watchBPHome readUsualModeHistoryDataIncludeEachMeasurement];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}

#pragma mark - DataResponseDelegate

@end
