//
//  YOECGLineView.h
//  ECGChartView
//
//  Created by Mac on 2021/6/4.
//

#import <UIKit/UIKit.h>
#import "YOECGParamter.h"
#import "YOECGHeader.h"

NS_ASSUME_NONNULL_BEGIN

@interface YOECGLineView : UIView

@property (nonatomic) YOECGParamter *standard;

/// 正电压大格子个数 默认4格
@property (nonatomic) int positiveNum;

/// 负电压的大格子个数 默认3格
@property (nonatomic) int negativeNum;

/// 画静态图
-(void)drawStaticECGLine:(NSArray *)voltageArr;

/// 实时心电图【双轨迹】
-(void)drawRealTimeECGTwoLine:(NSArray *)voltageArr;

/// 实时心电图 【单条轨迹】
-(void)drawRealTimeECGOneLine:(NSArray *)voltageArr;


-(void)clearData;

@end

NS_ASSUME_NONNULL_END
