//
//  ECGParamter.m
//  ECGChartView
//
//  Created by Mac on 2021/6/4.
//

#import "YOECGParamter.h"
#import <UIKit/UIKit.h>
@implementation YOECGParamter

-(instancetype)init{
    if (self = [super init]) {
        self.speed = 25;
        self.voltageSpecifications = 10;
        self.sampleFrequency = 256;
        self.oneGridSize = [self oneMillimetrePt] * 5;
        self.voltageUnit = YOECGChartViewVoltageUnitMilliVolt;
    }
    return self;
}

-(float)secodePerWidth{
    return self.speed;
}

-(float)onePointWidth{
    /**
     1 格子 = self.oneGridSize / 5.0
     1 格子 = 1mm
     1s走纸距离(格子数) = 速度 * 时间 => self.speed * 1 =  self.speed * 1
     1s走纸点数 = self.sampleFrequency;
     每个点的 pt 为 格子数 * 一个格子的距离 => self.speed * self.oneGridSize / 5.0
     */
    return self.speed * self.oneGridSize / 5.0 / self.sampleFrequency ;
}

-(float)onePointHeight{
    /**
     
     voltageSpecifications 纸张规格 10 mm/mV (一小格 0.1mV)  【不建议修改】
     
     1 格子 = self.oneGridSize / 5.0
     1 格子 = 1mm / 0.1mV
     1 格子 = 1mm / voltageSpecifications mm/mV  = (1.0 / voltageSpecifications )mV
     
     每个点的 pt 为 格子数 * 一个格子的距离 => self.speed * self.oneGridSize / 5.0
     */
    return self.oneGridSize / 5.0 / (1.0 / self.voltageSpecifications); // 每个距离的mV  =>  pt / mV
    
}

// 獲取設備型號
-(NSString *)getDeviceModel {
    struct utsname systemInfo;
    uname(&systemInfo);
    return [NSString stringWithCString:systemInfo.machine encoding:NSUTF8StringEncoding];
}
    
// 使用邏輯像素尺寸映射
- (NSDictionary<NSValue *, NSNumber *> *)logicalSizeToScreenSizeMap {
    static NSDictionary<NSValue *, NSNumber *> *map = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        map = @{
            // iPhone 型號及對應邏輯尺寸 (points) -> 實際螢幕尺寸 (inch)
            [NSValue valueWithCGSize:CGSizeMake(440, 956)]: @6.9,   // iPhone 16/17 Pro Max
            [NSValue valueWithCGSize:CGSizeMake(402, 874)]: @6.3,   // iPhone 16/17 Pro
            [NSValue valueWithCGSize:CGSizeMake(430, 932)]: @6.7,   // iPhone 14/15 Pro Max
            [NSValue valueWithCGSize:CGSizeMake(428, 926)]: @6.7,   // iPhone 12/13 Pro Max
            [NSValue valueWithCGSize:CGSizeMake(414, 896)]: @6.5,   // iPhone XS Max, 11 Pro Max
            [NSValue valueWithCGSize:CGSizeMake(393, 852)]: @6.1,   // iPhone 14/15 Pro
            [NSValue valueWithCGSize:CGSizeMake(390, 844)]: @6.1,   // iPhone 12/13/14/15/16/17 標準版
            [NSValue valueWithCGSize:CGSizeMake(375, 812)]: @5.8,   // iPhone X/XS/11 Pro, 12/13 mini
            [NSValue valueWithCGSize:CGSizeMake(414, 736)]: @5.5,   // iPhone 6/7/8 Plus
            [NSValue valueWithCGSize:CGSizeMake(375, 667)]: @4.7,   // iPhone 6/7/8, SE 2/3
            [NSValue valueWithCGSize:CGSizeMake(360, 780)]: @5.4,   // iPhone 12/13 mini
            [NSValue valueWithCGSize:CGSizeMake(320, 568)]: @4.0,   // iPhone 5/5s/5c/SE 1
            [NSValue valueWithCGSize:CGSizeMake(320, 480)]: @3.5,   // iPhone 4/4s

            // iPad 型號及對應邏輯尺寸 (points) -> 實際螢幕尺寸 (inch)
            [NSValue valueWithCGSize:CGSizeMake(1032, 1376)]: @13.0, // iPad Pro 13" M4
            [NSValue valueWithCGSize:CGSizeMake(1024, 1366)]: @12.9, // iPad Pro 12.9"
            [NSValue valueWithCGSize:CGSizeMake(834, 1210)]: @11.0,  // iPad Pro 11" M4
            [NSValue valueWithCGSize:CGSizeMake(834, 1194)]: @11.0,  // iPad Pro 11"
            [NSValue valueWithCGSize:CGSizeMake(820, 1180)]: @10.9,  // iPad Air 10.9", iPad 10.9"
            [NSValue valueWithCGSize:CGSizeMake(834, 1112)]: @10.5,  // iPad Air 10.5"
            [NSValue valueWithCGSize:CGSizeMake(810, 1080)]: @10.2,  // iPad 10.2"
            [NSValue valueWithCGSize:CGSizeMake(768, 1024)]: @9.7,   // iPad 9.7" (衝突處理)
            [NSValue valueWithCGSize:CGSizeMake(744, 1133)]: @8.3,   // iPad Mini 8.3"
        };
    });
    return map;
}

// 設備型號到螢幕尺寸的映射
- (NSDictionary<NSNumber *, NSArray<NSString *> *> *)screenSizeToModelsMap {
    static NSDictionary<NSNumber *, NSArray<NSString *> *> *map = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        map = @{
            // iPhone 系列
            @6.9: @[@"iPhone17,2", @"iPhone17,4"],
            @6.3: @[@"iPhone17,1", @"iPhone17,3", @"iPhone16,1", @"iPhone16,2"],
            @6.7: @[@"iPhone15,5", @"iPhone15,3", @"iPhone14,8", @"iPhone14,3", @"iPhone13,4", @"iPhone12,5"],
            @6.5: @[@"iPhone12,5", @"iPhone11,4", @"iPhone11,6"],
            @6.1: @[@"iPhone15,4", @"iPhone15,2", @"iPhone14,7", @"iPhone14,2", @"iPhone13,3", @"iPhone13,2", @"iPhone12,1", @"iPhone11,8"],
            @5.8: @[@"iPhone12,3", @"iPhone11,2", @"iPhone10,3", @"iPhone10,6"],
            @5.5: @[@"iPhone10,5", @"iPhone10,2", @"iPhone9,4", @"iPhone9,2", @"iPhone8,2", @"iPhone7,1"],
            @5.4: @[@"iPhone14,4", @"iPhone13,1"],
            @4.7: @[@"iPhone14,6", @"iPhone12,8", @"iPhone10,4", @"iPhone10,1", @"iPhone9,3", @"iPhone9,1", @"iPhone8,1", @"iPhone7,2"],
            @4.0: @[@"iPhone8,4", @"iPhone6,2", @"iPhone6,1", @"iPhone5,4", @"iPhone5,3", @"iPhone5,2", @"iPhone5,1"],
            @3.5: @[@"iPhone4,1", @"iPhone3,3", @"iPhone3,2", @"iPhone3,1", @"iPhone2,1", @"iPhone1,2", @"iPhone1,1"],

            // iPad 系列
            @13.0: @[@"iPad14,5", @"iPad14,6"],
            @12.9: @[@"iPad13,8", @"iPad13,9", @"iPad13,10", @"iPad13,11", @"iPad8,5", @"iPad8,6", @"iPad8,7", @"iPad8,8", @"iPad8,9", @"iPad8,10", @"iPad8,11", @"iPad8,12", @"iPad7,1", @"iPad7,2", @"iPad6,7", @"iPad6,8"],
            @11.0: @[@"iPad14,3", @"iPad14,4", @"iPad13,4", @"iPad13,5", @"iPad13,6", @"iPad13,7", @"iPad8,1", @"iPad8,2", @"iPad8,3", @"iPad8,4"],
            @10.9: @[@"iPad13,16", @"iPad13,17", @"iPad14,8", @"iPad14,9", @"iPad13,1", @"iPad13,2"],
            @10.5: @[@"iPad11,3", @"iPad11,4"],
            @10.2: @[@"iPad12,1", @"iPad12,2", @"iPad11,6", @"iPad11,7", @"iPad7,11", @"iPad7,12"],
            @9.7: @[@"iPad7,5", @"iPad7,6", @"iPad6,11", @"iPad6,12", @"iPad5,3", @"iPad5,4", @"iPad4,1", @"iPad4,2", @"iPad4,3", @"iPad3,1", @"iPad3,2", @"iPad3,3", @"iPad3,4", @"iPad3,5", @"iPad3,6", @"iPad2,1", @"iPad2,2", @"iPad2,3", @"iPad2,4", @"iPad1,1"],
            @8.3: @[@"iPad14,1", @"iPad14,2"],
            @7.9: @[@"iPad11,1", @"iPad11,2", @"iPad5,1", @"iPad5,2", @"iPad4,4", @"iPad4,5", @"iPad4,6", @"iPad4,7", @"iPad4,8", @"iPad4,9", @"iPad2,5", @"iPad2,6", @"iPad2,7"]
        };
    });
    return map;
}
    
-(float)oneMillimetrePt {
    // 獲取屏幕邏輯尺寸和原生尺寸
    CGFloat sc_w = [[UIScreen mainScreen] bounds].size.width;
    CGFloat sc_h = [[UIScreen mainScreen] bounds].size.height;

    // 標準化邏輯尺寸，確保 width 是較小值
    CGSize logicalSize = CGSizeMake(sc_w, sc_h);
    if (logicalSize.width > logicalSize.height) {
        logicalSize = CGSizeMake(logicalSize.height, logicalSize.width);
    }

    // 獲取設備型號信息
    NSString *deviceModel = [self getDeviceModel];

    // 獲取螢幕尺寸
    CGFloat screenSizeInch = [self getScreenSizeWithLogicalSize:logicalSize
                                                    deviceModel:deviceModel
                                     logicalSizeToScreenSizeMap:self.logicalSizeToScreenSizeMap
                                          screenSizeToModelsMap:self.screenSizeToModelsMap];

    // 計算對角線邏輯點數
    CGFloat diagonalPoints = sqrt(sc_w * sc_w + sc_h * sc_h);

    // 計算每毫米的邏輯點數 (1 inch = 25.4 mm)
    CGFloat screenSizeMM = screenSizeInch * 25.4;
    float pointsPerMM = diagonalPoints / screenSizeMM;

    NSLog(@"📱 螢幕計算 - 邏輯尺寸: %.0f×%.0f, 實際: %.1f\", 每毫米: %.3f points",
    logicalSize.width, logicalSize.height, screenSizeInch, pointsPerMM);

    return pointsPerMM;
}

// 獲取螢幕尺寸
-(CGFloat)getScreenSizeWithLogicalSize:(CGSize)logicalSize
                           deviceModel:(NSString *)deviceModel
            logicalSizeToScreenSizeMap:(NSDictionary<NSValue *, NSNumber *> *)logicalSizeToScreenSizeMap
                 screenSizeToModelsMap:(NSDictionary<NSNumber *, NSArray<NSString *> *> *)screenSizeToModelsMap {
  
    CGFloat screenSizeInch = 0.0;
    CGFloat screenSizeInch4DeviceModel = 0.0;
    CGFloat screenSizeInch4UIScreen = 0.0;

    // 主要方法：型號匹配（無衝突，最可靠）
    for (NSNumber *sizeKey in screenSizeToModelsMap) {
        NSArray<NSString *> *models = screenSizeToModelsMap[sizeKey];
        if ([models containsObject:deviceModel]) {
            screenSizeInch4DeviceModel = [sizeKey floatValue];
            break;
        }
    }
    
    // 驗證方法：邏輯尺寸匹配
    NSValue *sizeValue = [NSValue valueWithCGSize:logicalSize];
    NSNumber *sizeFromLogical = logicalSizeToScreenSizeMap[sizeValue];
    if (sizeFromLogical) {
        screenSizeInch4UIScreen = [sizeFromLogical floatValue];
    }
    
    // 優先取型號結果
    if (screenSizeInch4DeviceModel == screenSizeInch4UIScreen) {
        screenSizeInch = screenSizeInch4DeviceModel;    // 一致時取型號結果
    } else if (screenSizeInch4DeviceModel > 0) {
        screenSizeInch = screenSizeInch4DeviceModel;    // 只有型號結果
    } else if (screenSizeInch4UIScreen > 0) {
        screenSizeInch = screenSizeInch4UIScreen;       // 只有邏輯尺寸結果
    }

    return screenSizeInch > 0 ? screenSizeInch : 6.1; // 預設值
}

-(BOOL)parameterIsRight{
    return self.speed * self.sampleFrequency * self.voltageSpecifications * self.oneGridSize > 0;
}


@end
