//
//  YOECGChartView.h
//  ECGChartView
//
//  Created by Mac on 2021/6/4.
//

#import <UIKit/UIKit.h>
#import "YOECGParamter.h"
#import "YOECGLineView.h"
#import "YOECGBackGroundGridView.h"
#import "YOECGHeader.h"

NS_ASSUME_NONNULL_BEGIN

@interface YOECGChartView : UIView

/// 心电图相关参数
@property (nonatomic) YOECGParamter *standard;

/// 网格视图
@property (strong, nonatomic) YOECGBackGroundGridView *gridView;

/// 心电图视图
@property (strong, nonatomic) YOECGLineView *ecgView;

/// 0点位以上的大格子个数 默认4格
@property (nonatomic) int positiveNum;

/// 0点位以上的大格子个数 默认4格
@property (nonatomic) int negativeNum;

/// 多軌画静心电图 軌道最大秒數 默認10秒
@property (nonatomic) int statictiveNum;

/// 多軌画静心电图 紀錄最大秒數
@property (nonatomic) int statictiveMaxNum;

/// 画静心电图【單軌】
-(void)drawStaticECGLine:(NSArray *)voltageArr;

/// 画静心电图【YES 單軌 ,NO 多軌】
-(void)drawStaticECGLine:(NSArray *)voltageArr oneLine:(BOOL)oneLine;

/// 实时心电图绘制之前，需要reload 网格线条
-(void)reloadGridView;

/// 实时心电图【双轨迹】
-(void)drawRealTimeECGLine:(NSArray *)voltageArr;

/// 实时心电图【YES 双轨迹 ,NO 单轨迹】
-(void)drawRealTimeECGLine:(NSArray *)voltageArr twoLine:(BOOL)twoLine;


-(void)refreshSubViewFrame;

/// 修改配置参数后刷新视图
-(void)reload;

//
- (NSMutableArray *)pdfImages;

//
- (NSString *)pdfPath;

@end

NS_ASSUME_NONNULL_END
