//
//  spoDrawView.m
//  Microlife
//
//  Created by willy.wu on 2020/12/15.
//  Copyright © 2020 Rex. All rights reserved.
//

#import "spoDrawView.h"

@implementation spoDrawView

- (void)layoutSubviews{
    [super layoutSubviews];
    self.showLayer.frame = self.bounds;
}

- (CAShapeLayer *)showLayer{
    if (!_showLayer) {
        _showLayer = [CAShapeLayer new];
        _showLayer.lineWidth = 1;
        _showLayer.strokeColor = [UIColor systemBlueColor].CGColor;
        _showLayer.fillColor = [UIColor clearColor].CGColor;
        [self.layer addSublayer:_showLayer];
    }
    return _showLayer;
}

- (CAGradientLayer *)grandient {
    if (!_grandient) {
        _grandient = [CAGradientLayer layer];
        _grandient.frame = self.bounds;//设置颜色渐变的layer的frame
//        grandient.colors = colors;//颜色数组
        _grandient.mask = self.showLayer;//设置mask图层
        //开始和结束点可以用来做隐式动画
//        _grandient.startPoint = CGPointMake(0, 0);//开始点
//        _grandient.endPoint = CGPointMake(1, 0);//结束点
        [self.layer addSublayer:_grandient];
    }
    return _grandient;
}

@end
