//
//  MicroLife3GBP.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/7.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMD3G) {
    CMD3GReadHistorys = 0x00,
    CMD3GClearAllHistorys = 0x03,
    CMD3GDisconnect = 0x04,
    CMD3GReadUserAndVersionData = 0x05,
    CMD3GWriteUser = 0x06,
    CMD3GReadLastData = 0x07,
    CMD3GClearLastData = 0x08,
    CMD3GReadDeviceInfo = 0x0B,
    CMD3GReplyACK = 0x81,
    CMD3GReplyNACK = 0x91,
    CMD3GReplyNullACK = 0x92
};
NS_ASSUME_NONNULL_BEGIN

@interface MicroLife3GBP : MicroLifeDevice

/// read all history or current data from bpm
- (void)readHistorys;

/// clear all history data from bpm
- (void)clearAllHistorys;

/// disconnect
- (void)disconnect;

/// read user id and version data from bpm
- (void)readUserAndVersionData;

/// write a new user id & age
/// @param ID userID (Must be a 9-digit string 2-english string)
/// @param age age
- (void)writeUserData:(NSString *)ID Age:(NSInteger)age;

/// Read last 1 data from the BPM  [Attention] will not respond!
- (void)readLastData;

/// Clear last 1 data of the BPM [Attention] will not respond!
- (void)clearLastData;

/// read Device information
- (void)readDeviceInfo;

@end

NS_ASSUME_NONNULL_END
