//
//  MicroLifeBloodPressureDRecord.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/8.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeBloodPressureDRecord : MicroLifeDataModel

/**
 Mode:The Value Of This Flag Is fixed to 0x00
 */
@property (nonatomic, strong) NSNumber *mode;

/**
 CurrentMode:
 0: BP_Single_MODE
 1: BP_Single_MODE + SW Afib ON 2: BP_MAM_MODE
 3: BP_MAM_MODE + SW Afib ON
 */
@property (nonatomic, strong) NSNumber *currentMode;

/**
 History Measurement times:
 PUBLIC COMMUNICATION SPECIFICATION FOR BLE /USB
 The history measurement times store in memory.
 */
@property (nonatomic, strong) NSNumber *historyMeasurementNumber;

/**
 UserNumber:User1=1,User2=2,Guest=3
 */
@property (nonatomic, strong) NSNumber *userNumber;

/**
 MAMversion:0x00=MAMweight,0x01=MAMlight,0Xff=NoMAMfunction.
 The MAM result is calculated by simple arithmetic mean (MAM light) or weighted mean (MAM weight).
 */
@property (nonatomic, strong) NSNumber *MAMState;

/**
 Newest blood pressure measurement data[Reserved]
 */
@property (nonatomic, strong) NSMutableArray *currentData;

/**
 All blood pressure menasurement data
 */
@property (nonatomic, strong) NSMutableArray *MData;

@end

NS_ASSUME_NONNULL_END
