//
//  MicroLifeBodyFat.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/2/2.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeBodyFat : MicroLifeDataModel

/**
 * User role type for measurement data classification
 *
 * Determines how measurement data should be processed and stored:
 * - Guest: Temporary measurement, no data persistence
 * - Normal: Confirmed user identity, save to user profile
 * - MultiUser: Ambiguous user match, requires manual user selection
 *
 * Used in offline mode to handle user identification:
 * - When weight matches single user: Normal data (MicroLifeUserRoleTypeNormal)
 * - When weight matches multiple users: Doubt data (MicroLifeUserRoleTypeMultiUser)
 * - When no user match or guest mode: Guest data (MicroLifeUserRoleTypeGuest)
 */
@property (nonatomic, assign) MicroLifeUserRoleType roleType;

/// User No Current user
@property (nonatomic, strong) NSNumber *userNo;

/**
 * Measured member ID
 */
@property (nonatomic,copy) NSString *userId;

/// Year
@property (nonatomic, strong) NSNumber *year;

/// Month
@property (nonatomic, strong) NSNumber *month;

/// Date
@property (nonatomic, strong) NSNumber *day;

/// Hour
@property (nonatomic, strong) NSNumber *hour;

/// Minte
@property (nonatomic, strong) NSNumber *minute;

/// Second
@property (nonatomic, strong) NSNumber *second;

/**
 * Weight
 * Unit: kg
 */
@property (nonatomic, strong) NSNumber *weight;

/**
 * bone amount
 * Unit: kg
 */
@property (nonatomic, strong) NSNumber *bone;

/**
 * Fat rate
 * Unit: %
 */
@property (nonatomic, strong) NSNumber *fat;

/**
 * Visceral fat level
 */
@property (nonatomic, strong) NSNumber *visceralfat;

/**
 * Moisture rate
 * Unit: %
 */
@property (nonatomic, strong) NSNumber *moisture;

/**
 * Basal metabolic rate
 * Unit: kcal/d
 */
@property (nonatomic, strong) NSNumber *bmr;

/**
 * BMI
 */
@property (nonatomic, strong) NSNumber *bmi;

/**
 * Body impedance
 */
@property (nonatomic, strong) NSNumber *resistance;

/**
 * Protein
 * Unit: %
 */
@property (nonatomic, strong) NSNumber *protein;

/**
 * skeletal muscle
 * Unit: kg
 */
@property (nonatomic, strong) NSNumber *boneMuscle;

/**
 * muscle
 * Unit: kg
 */
@property (nonatomic, strong) NSNumber *muscle;

/**
 * bodyScore 0-100
 */
@property (nonatomic, strong) NSNumber *bodyScore;

/**
 * bodyAge
 */
@property (nonatomic, strong) NSNumber *bodyAge;

/**
   Is it doubt data?
  
   Measurement in offline mode:
   If the user's weight matches a certain user stored in the scale, it is said to save the offline measurement data to the user, which is normal data;
   If the user's weight matches a certain number of users stored in the scale, it is said that for each matched user, the offline measurement data is saved, and this is doubt data;
 */
@property (nonatomic,strong) NSNumber *isSuspectedData;

- (void)adjustAge:(NSNumber *)age Gender:(MicroLifeUserGender)gender Height:(NSNumber *)height;

- (void)adjustEthnicity:(MicroLifeUserEthnicity)ethnicity Age:(NSNumber *)age Gender:(MicroLifeUserGender)gender Height:(NSNumber *)height;

#pragma mark - WS200
/**
 * Weight unit (kg/lb)
 */
@property (nonatomic,assign) MicroLifeEBUnitType unit;

/// Week
@property (nonatomic, strong) NSNumber *week;

- (void)analysis:(MicroLifeDeviceType)deviceType CMD:(NSInteger)CMD Data:(id)value UUID:(NSString *)UUID Mac:(NSData *)mac ProtocolID:(NSNumber *)protocolID User:(NSString *)ID Age:(NSNumber *)age Gender:(MicroLifeUserGender)gender Height:(NSNumber *)height RoleType:(MicroLifeUserRoleType)roleType;

@end

NS_ASSUME_NONNULL_END
