//
//  MicroLifeDeviceSDK.h
//  MicroLifeDeviceSDK
// 
//  Created by willy.wu on 2020/11/18.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>

// SDK print Log
#define kMicroLifeDeviceSDKShowLog(showLog) [[LogManager sharedInstance] setShowLog:showLog];

// SDK send support Email
#define kMicroLifeDeviceSDKSendSupportMail(ID,type,info,app_Name,app_Version,user_Name) [[LogManager sharedInstance] sendSupportMailWith:ID Type:type Info:info AppName:app_Name AppVersion:app_Version User:user_Name];

#define kMicroLifeDeviceSDKSendSupportMails(ID,type,info,app_Name,app_Version,user_Name,emails) [[LogManager sharedInstance] sendSupportMailWith:ID Type:type Info:info AppName:app_Name AppVersion:app_Version User:user_Name Emails:emails];

// SDK Get Log Zip
#define kMicroLifeDeviceSDKLogZip [[LogManager sharedInstance] getLogZipPath];

// SDK Add Log File
#define kMicroLifeDeviceSDKAddLogFile(url) [[LogManager sharedInstance] addLogFile:url];

// SDK Set Log Max Save Day
#define kMicroLifeDeviceSDKLogMaxSaveDay(logMaxSaveDay) [[LogManager sharedInstance] setMaxSaveDay:logMaxSaveDay];

// Set Cloud Sever
#define kMicroLifeDeviceSDKSever(severType) [MicroLifeCloudManager setMainSeverType:severType];

//! Project version number for MicroLifeDeviceSDK.
FOUNDATION_EXPORT double MicroLifeDeviceSDKVersionNumber;

//! Project version string for MicroLifeDeviceSDK.
FOUNDATION_EXPORT const unsigned char MicroLifeDeviceSDKVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <MicroLifeDeviceSDK/PublicHeader.h>

// ========================== 基礎功能 (Basic Functions) ==========================
// 日誌與加密 (Log Management and Encryption)
#import <MicroLifeDeviceSDK/LogManager.h> // 日誌管理 (Log Management)
#import <MicroLifeDeviceSDK/Encrypt.h>    // 加密功能 (Encryption)

// 雲端核心 (Cloud Core)
#import <MicroLifeDeviceSDK/CloudManager.h>   // 雲端管理 (Cloud Manager)
#import <MicroLifeDeviceSDK/CloudDataModel.h> // 雲端數據模型 (Cloud Data Model)

// 雲端 API (Cloud API)
#import <MicroLifeDeviceSDK/MicroLifeCloud2GManager.h>   // 雲端 2G 管理 (Cloud 2G Manager)
#import <MicroLifeDeviceSDK/MicroLifeCloudDataModel.h>   // 雲端數據模型 (Cloud Data Model)

// ========================== 藍牙相關功能 (Bluetooth Functions) ==========================
// 藍牙核心 (Bluetooth Core)
#import <MicroLifeDeviceSDK/BluetoothCallbacks.h>         // 定義所有回調類型 (Defines all callback types)
#import <MicroLifeDeviceSDK/BluetoothManagerProtocol.h>   // 定義統一協議 (Defines unified protocol)

// 藍牙 SDK (Bluetooth SDK)
#import <MicroLifeDeviceSDK/BLESDK.h>            // 藍牙 SDK (Bluetooth SDK)
#import <MicroLifeDeviceSDK/BLEDeviceInfo.h>     // 藍牙 設備資訊 (Bluetooth Device Info)
#import <MicroLifeDeviceSDK/MicroLifeDevice.h>   // MicroLife 設備管理 (MicroLife Device Management)
#import <MicroLifeDeviceSDK/MicroLifeDataModel.h> // MicroLife 數據模型 (MicroLife Data Model)

// ========================== 資料模型 (Data Models) ==========================
#import <MicroLifeDeviceSDK/MicroLifeDeviceInfo.h> // 設備信息模型 (Device Info Model)
#import <MicroLifeDeviceSDK/MicroLifeUserInfo.h>   // 用戶信息模型 (User Info Model)
#import <MicroLifeDeviceSDK/MicroLifeGATTValue.h>  // GATT 值模型 (GATT Value Model)

// ========================== 健康數據模組 (Health Data Modules) ==========================
// 體溫測量 (Temperature Measurement)
#import <MicroLifeDeviceSDK/MicroLifeTemperature.h>           // 體溫測量功能 (Temperature Measurement Functions)
#import <MicroLifeDeviceSDK/MicroLifeTemperatureMeasureData.h> // 體溫測量數據 (Temperature Measurement Data)

// 血壓測量 (Blood Pressure Measurement)
#import <MicroLifeDeviceSDK/MicroLife3GBP.h>                          // 血壓測量 (3G BP Measurement)
#import <MicroLifeDeviceSDK/MicroLife4GBP.h>                          // 血壓測量 (4G BP Measurement)
#import <MicroLifeDeviceSDK/MicroLife5GBP.h>                          // 血壓測量 (5G BP Measurement)
#import <MicroLifeDeviceSDK/MicroLifeBloodPressureDRecord.h>          // 血壓數據記錄 (Blood Pressure Data Record)
#import <MicroLifeDeviceSDK/MicroLifeBloodPressureCurrentAndMData.h>  // 當前與平均血壓數據 (Current and Mean BP Data)

// 體重與體脂 (Weight and Body Fat)
#import <MicroLifeDeviceSDK/MicroLifeWS200.h>    // WS200測量 (WS200 Measurement )
#import <MicroLifeDeviceSDK/MicroLifeWS500.h>    // WS500測量 (WS500 Measurement )
#import <MicroLifeDeviceSDK/MicroLifeBodyFat.h>  // 體脂測量 (Body Fat Measurement)

// 血氧測量 (Oxygen Measurement)
#import <MicroLifeDeviceSDK/MicroLifeOxygen.h>    // 血氧測量功能 (Oxygen Measurement Functions)
#import <MicroLifeDeviceSDK/MicroLifeOxygenData.h> // 血氧測量數據 (Oxygen Measurement Data)

// 心電圖測量 (Electrocardiography - ECG)
#import <MicroLifeDeviceSDK/MicroLifeECG.h>                        // 心電圖測量功能 (ECG Measurement Functions)
#import <MicroLifeDeviceSDK/MicroLifeECGDRecord.h>                 // 心電圖數據記錄 (ECG Data Record)
#import <MicroLifeDeviceSDK/MicroLifeECGMData.h>                   // 心電圖測量數據 (ECG Measurement Data)
#import <MicroLifeDeviceSDK/MicroLifeECGInformationData.h>         // 心電圖信息數據 (ECG Information Data)
#import <MicroLifeDeviceSDK/MicroLifeECGFunctionSettingValues.h>   // 心電圖功能設置值 (ECG Function Setting Values)
#import <MicroLifeDeviceSDK/MicroLifeECGSettingValues.h>           // 心電圖設置值 (ECG Setting Values)
#import <MicroLifeDeviceSDK/MicroLifeECGDeviceCurrentStatus.h>     // 心電圖設備當前狀態 (ECG Device Current Status)
#import <MicroLifeDeviceSDK/MicroLifeECGRawData.h>                 // 心電圖原始數據 (ECG Raw Data)
#import <MicroLifeDeviceSDK/MicroLifeECGSampleData.h>              // 心電圖樣本數據 (ECG Sample Data)

// 血糖測量 (Blood Sugar Measurement)
#import <MicroLifeDeviceSDK/MicroLifeBGM800.h>            // 血糖測量 (BGM800)
#import <MicroLifeDeviceSDK/MicroLifeBGM800MeasureData.h> // 血糖測量數據 (BGM800 Measurement Data)
#import <MicroLifeDeviceSDK/MicroLifeBGM700.h>            // 血糖測量 (BGM700)
#import <MicroLifeDeviceSDK/MicroLifeBGM700MeasureData.h> // 血糖測量數據 (BGM700 Measurement Data)

// 呼吸流量測量 (Peakflow Measurement)
#import <MicroLifeDeviceSDK/MicroLifePFM.h>               // 呼吸流量測量功能 (Peakflow Measurement Functions)
#import <MicroLifeDeviceSDK/MicroLifePFMDRecord.h>        // 呼吸流量數據記錄 (Peakflow Data Record)
#import <MicroLifeDeviceSDK/MicroLifePFMCurrentAndMData.h> // 當前與平均呼吸數據 (Current and Mean Peakflow Data)
#import <MicroLifeDeviceSDK/MicroLifePFMWaveformRecord.h> // 呼吸波形數據記錄 (Peakflow Waveform Record)

// PPG 測量 (PPG Measurement)
#import <MicroLifeDeviceSDK/MicroLifePPG.h>                          // PPG 測量功能 (PPG Measurement Functions)
#import <MicroLifeDeviceSDK/MicroLifePPGDRecord.h>                   // PPG 數據記錄 (PPG Data Record)
#import <MicroLifeDeviceSDK/MicroLifePPGUsualModeHistoryData.h>      // PPG 常規模式歷史數據 (PPG Usual Mode History Data)
#import <MicroLifeDeviceSDK/MicroLifePPGDiagnosticModeHistoryData.h> // PPG 診斷模式歷史數據 (PPG Diagnostic Mode History Data)
#import <MicroLifeDeviceSDK/MicroLifePPGABPMModeHistoryData.h>       // PPG ABPM 模式歷史數據 (PPG ABPM Mode History Data)
#import <MicroLifeDeviceSDK/MicroLifePPGSettingValues.h>             // PPG 設置值 (PPG Setting Values)

// ========================== WatchBP 系列 (WatchBP Series) ==========================
#import <MicroLifeDeviceSDK/MicroLifeWatchBPHome.h>                     // WatchBP Home
#import <MicroLifeDeviceSDK/MicroLifeWatchBPO3.h>                       // WatchBP O3
#import <MicroLifeDeviceSDK/MicroLifeWatchBPOffice.h>                   // WatchBP Office
#import <MicroLifeDeviceSDK/MicroLifeWatchBPM1.h>                       // WatchBP M1
#import <MicroLifeDeviceSDK/MicroLifeWatchBPOfficeVascular.h>           // WatchBP Office Vascular
#import <MicroLifeDeviceSDK/MicroLifeWatchBPDRecord.h>                  // WatchBP 數據記錄 (WatchBP Data Record)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPCurrentAndMData.h>          // 當前與平均血壓數據 (Current and Mean BP Data)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPIncludeEachMeasurementData.h> // 包含每次測量數據 (Include Each Measurement Data)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPCBPdataAndCalCBP.h>         // CBP 數據與計算 (CBP Data and Calculation)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPSettingValues.h>            // WatchBP 設置值 (WatchBP Setting Values)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPFunctionSettingValues.h>    // WatchBP 功能設置值 (WatchBP Function Setting Values)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPDiagnosticDRecord.h>        // WatchBP 診斷數據記錄 (WatchBP Diagnostic Data Record)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPNocturnalModeDRecord.h>     // 夜間模式數據記錄 (Nocturnal Mode Data Record)
#import <MicroLifeDeviceSDK/MicroLifeWatchBPRemoteMeasurement.h>        // 遠程測量功能 (Remote Measurement)
