//
//  MicroLifeECGMData.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/20.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeECGMData : MicroLifeDataModel

/// Condition
/// 0       BP          ECG feature off. Only measure blood pressure
/// 30      BP_ECGNA    ECG feature on. Measure blood pressure but not trigger ECG.
/// 31      BP_ECG      ECG feature on. Measure blood pressure, and then trigger ECG.
/// 32      ECG         ECG feature on. Only measure ECG.
@property (nonatomic, strong) NSNumber *condition;

/// Systolic
@property (nonatomic, strong) NSNumber *sys;

/// Diastolic
@property (nonatomic, strong) NSNumber *dia;

/// Pulse
@property (nonatomic, strong) NSNumber *hr;

/// Used For calibrate ECG voltage , 100= 100% (normal range should : 90~110% )
@property (nonatomic, strong) NSNumber *SWGain;

/// Year
@property (nonatomic, strong) NSNumber *year;

/// Month
@property (nonatomic, strong) NSNumber *month;

/// Date
@property (nonatomic, strong) NSNumber *day;

/// Hour
@property (nonatomic, strong) NSNumber *hour;

/// Minte
@property (nonatomic, strong) NSNumber *minute;

/// Second
@property (nonatomic, strong) NSNumber *second;

/// Detect AFib by blood pressure.
@property (nonatomic, strong) NSNumber *AFIb;

/// Detect IHB by blood pressure.
@property (nonatomic, strong) NSNumber *IHB;

/// Measure blood pressure with appropriate cuff fit
@property (nonatomic, strong) NSNumber *cuffokr;

/// Measure blood pressure with warming battery voltage
@property (nonatomic, strong) NSNumber *LB;

/// Blood pressure measurement mode:
/// 0: BP_Single_MODE
/// 1: BP_Single_MODE + SW Afib ON
/// 2: BP_MAM_MODE
/// 3: BP_MAM_MODE + SW Afib ON
@property (nonatomic, strong) NSNumber *mode;

/// ECG sample rate: 0:128, 1:256, 2:512 sps
@property (nonatomic, assign) SampleRate SP;

/// Product type:
/// 0 : event recorder with blood pressure monitor
@property (nonatomic, strong) NSNumber *ECGtype;

/// ECG frontend digital filter (0:off , 1:on)
@property (nonatomic, strong) NSNumber *hwfilter;

/// ECG Code
@property (nonatomic, assign) ECGcode ECGCode;

/// Length: (sample time)
/// 0:N/A, 1:30 seconds, 2:60seconds
@property (nonatomic, assign) SsampleTime length;

@property (nonatomic, assign) NSInteger index;

@end

NS_ASSUME_NONNULL_END
