//
//  MicroLifePPG.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2023/10/27.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger, CMDPPG) {
    CMDPPGReadUsualModeHistoryData = 0x00,
    CMDPPGReadDiagnosticModeHistoryData = 0x01,
    CMDPPGClearSelectedModeHistoryData = 0x02,
    CMDPPGReadABPMModeHistoryData = 0x03,
    CMDPPGDisconnect = 0x04,
    CMDPPGReadUserIDAndVersion = 0x05,
    CMDPPGWriteUserID = 0x06,
    CMDPPGWriteDeviceInfo = 0x0A,
    CMDPPGReadDeviceInfo = 0x0B,
    CMDPPGReadDeviceTime = 0x0C,
    CMDPPGWriteDeviceTime = 0x0D,
    CMDPPGReadDeviceStatus = 0x10,
    CMDPPGReadSerialNumber = 0x0F,
    CMDPPGReadABPMModeSetting2Schedules = 0x17,
    CMDPPGWriteABPMModeSetting2Schedules = 0x18,
    CMDPPGReadABPMModeSetting5Schedules = 0x19,
    CMDPPGWriteABPMModeSetting5Schedules = 0x1A,
    CMDPPGEraseAllMeasureAndErrorTimes = 0x1D,//(Only for factory use)
    CMDPPGReadMeterFunctionSetting = 0x1E,
    CMDPPGWriteMeterFunctionSetting = 0x1F,//(Only for factory use)
    CMDPPGCalibrationBPQuery = 0x20,
    CMDPPGCADUBPCalibrationBPSet = 0x21,
    CMDPPGOpenBPDetectionTimer = 0x22,
    CMDPPGCloseBPDetectionTimer = 0x23,
    CMDPPGResetDevice = 0x2F,
    CMDPPGReplyACK = 0x81,
    CMDPPGReplyNACK = 0x91,
    CMDPPGReplyNullACK = 0x92
};

@interface MicroLifePPG : MicroLifeDevice

/// Read usual mode history data.
- (void)readUsualModeHistoryData;

/// Read diagnostic mode history data.
- (void)readDiagnosticModeHistoryData;

/// Clear selected mode history data.
/// - Parameters:
///   - clearUsualMode: clear Usual Mode
///   - clearDiagnosticlMode: clear Diagnosticl Mode
///   - clearABPMMode: clear ABPM Mode
///   - clearPillMode: clear Pill Mode
- (void)clearSelectedModeHistoryData:(BOOL)clearUsualMode DiagnosticMode:(BOOL)clearDiagnosticlMode ABPMMode:(BOOL)clearABPMMode PillMode:(BOOL)clearPillMode;

/// Read ABPM mode history data.
/// - Parameter mapType: mapType
///     MicroLifeMAPTypeOscillometric: Oscillometric MAP
///     MicroLifeMAPTypeFormula: Formula MAP (MAP=1/3 SYS+ 2/3 DIA)
- (void)readABPMModeHistoryData:(MAPType)mapType;

/// Disconnect from the device.
- (void)disconnect;

/// Read user ID and version information.
- (void)readUserIDAndVersion;

/// Write user ID.
/// - Parameter ID: user ID
- (void)writeUserID:(NSString *)ID;

/// Write device information.
- (void)writeDeviceInfo;

/// Read device information.
- (void)readDeviceInfo;

/// Read device time.
- (void)readDeviceTime;

/// Write device time.
- (void)writeDeviceTime;

/// Read device status.
- (void)readDeviceStatus;

/// Read serial number.
- (void)readSerialNumber;

/// Write serial number (Only for factory use).
- (void)writeSerialNumber;

/// Read ABPM mode setting for 2 schedules.
- (void)readABPMModeSetting2Schedules;

/// Write ABPM mode setting for 2 schedules.
/// - Parameters:
///   - start: The start time of the schedule.
///   - end: The end time of the schedule.
///   - firstInterval: The first interval of the schedule.
///   - secondInterval: The second interval of the schedule.
///   - HI_infPressure: The HI_infPressure of the schedule.
///   - SW_checkhide: The SW_checkhide of the schedule.
///   - silent: The silent mode of the schedule.
- (void)writeABPMModeSetting2SchedulesStart:(NSInteger)start End:(NSInteger)end firstInterval:(Interval)firstInterval secondInterval:(Interval)secondInterval HI_infPressure:(HIinfPressure)HI_infPressure SW_checkhide:(BOOL)SW_checkhide silent:(BOOL)silent;

/// Read ABPM mode setting for 5 schedules.
- (void)readABPMModeSetting5Schedules;

/// Write ABPM mode setting for 5 schedules.
- (void)writeABPMModeSetting5Schedules;

/// Erase all measurement and error times (Only for factory use).
/// - Parameter offsetYear: offset year
- (void)eraseAllMeasureAndErrorTimes:(NSInteger)offsetYear;

/// Read meter function setting.
- (void)readMeterFunctionSetting;

/// Write meter function setting (Only for factory use).
- (void)writeMeterFunctionSetting;

/// Query calibration for BP.
- (void)calibrationBPQuery;

/// Set CADUBP calibration for BP.
- (void)setCADUBPCalibrationBP;

/// Open BP detection timer.
- (void)openBPDetectionTimer;

/// Close BP detection timer.
- (void)closeBPDetectionTimer;

/// Reset the device.
- (void)resetDevice;

@end

NS_ASSUME_NONNULL_END
