//
//  MicroLifePPGABPMModeHistoryData.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2023/10/30.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifePPGABPMModeHistoryData : MicroLifeDataModel

/**
 Systolic
 */
@property (nonatomic, strong) NSNumber *sys;

/**
 Diastolic
 */
@property (nonatomic, strong) NSNumber *dia;

/**
 Pulse
 */
@property (nonatomic, strong) NSNumber *hr;

/**
 Year
 */
@property (nonatomic, strong) NSNumber *year;

/**
 Month
 */
@property (nonatomic, strong) NSNumber *month;

/**
 Date
 */
@property (nonatomic, strong) NSNumber *day;

/**
 Hour
 */
@property (nonatomic, strong) NSNumber *hour;

/**
 Minte
 */
@property (nonatomic, strong) NSNumber *minute;

/**
 the data is measured in diagnostic mode
 */
@property (nonatomic, strong) NSNumber *diagnostic;

/**
 the data is measured in night with diagnostic mode (ex. 4:00~12:00)
 */
@property (nonatomic, strong) NSNumber *AM;

/**
 the data is measured in morning with diagnostic mode (ex. 18:00~24:00)
 */
@property (nonatomic, strong) NSNumber *PM;

/**
 AFIb (If both detect Afib and IHB, only display Afib)
 */
@property (nonatomic, strong) NSNumber *AFIb;

/// MAP Type:
/// 0: Oscillometric MAP
/// 1: Formula MAP (MAP=1/3 SYS+ 2/3 DIA)
@property (nonatomic, assign) MAPType mapType;

/**
 Error code     Error Message     Description     Remark
 0x01     Error 1     Signals is too weak     "1.The cuff pressure is lower than 40 mmHg and there is no signal from cuff. 2.The cuff pressure is lower than 12 mmHg and there are some signals from the cuff but not detect systolic pressure and diastolic pressure."
 0x02    Error 2    Error signal    There are some artifact signals from the cuff
 0x03    Error 3    No pressure in the cuff    "If total pump time is over 62 seconds.
 If pressure is less than 15 mmHg and the pump time is over 12 seconds.
 The pressure is over 299 mmHg.
 The total measurement time is over 165 second"
 0x05    Error 5    Abnormal result    "1.    The difference between systolic pressure and diastolic pressure is less than 11 mmHg or more than 153 mmHg.
 2.    SYS>255 or DIA>200
 3.    SYS<60 or DIA<30
 4.    SYS<MAP or DIA>MAP
 ※The follow condition only established in Ambulatory mode:
 1. Heart rate is less than 40 BPM.
 2. “ABPM SYS,DIA, MAP ratio condition”
 "
 0x42    Error B    Low battery    The batteries need to be replaced.
 0x46    Error F    Single fault     Occurs single fault condition
 */
@property (nonatomic, strong) NSNumber *errorCode;
@property (nonatomic, strong) NSString *errorMessage;
@end

NS_ASSUME_NONNULL_END
