//
//  MicroLifePPGSettingValues.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2023/10/30.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifePPGSettingValues : MicroLifeDataModel

/**
 *  The starting time of the first measurement time zone (valid range: 0~23)
 * */
@property (nonatomic, strong) NSNumber *start;

/**
 *  The end time of the first measurement time zone (valid range: 0~23)
 * */
@property (nonatomic, strong) NSNumber *end;

/**
 *  The interval of the first Interval zone (valid range: 5, 10, 15, 20, 30, and 60)
 * */
@property (nonatomic, assign) Interval firstInterval;

/**
 *  The interval of the second Interval zone (valid range: 5, 10, 15, 20, 30, and 60)
 * */
@property (nonatomic, assign) Interval secondInterval;

/**
 Highest inflation pressure of Auto mode
 
 Valid parameter: 0(not setting), 140, 160, 180, 200, 220, 240, 280
 
 The device inflates the cuff using fuzzy logic to proper cuff pressure; the Highest Inflation Pressure is considered as a safeguard pressure
 */
@property (nonatomic, assign) HIinfPressure HI_infPressure;

/// (valid range: 5,10,15,20,30,60, 255:diable
@property (nonatomic, assign) Interval Interval;

/**
 *  Beeper true:enabled/false:disabled
 * */
@property (nonatomic, strong) NSNumber *silent;
/**
 *  Hide(true)/Show(false) readings after measurement
 * */
@property (nonatomic, strong) NSNumber *SW_checkhide;

/// [(5 schedule)] ABPM Setting Values
@property (nonatomic, strong) NSMutableArray *settingValues;

- (BOOL)checkSettingValues;

@end

NS_ASSUME_NONNULL_END
