//
//  MicroLifePPGUsualModeHistoryData.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2023/10/27.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifePPGUsualModeHistoryData : MicroLifeDataModel

/**
 Systolic
 */
@property (nonatomic, strong) NSNumber *sys;

/**
 Diastolic
 */
@property (nonatomic, strong) NSNumber *dia;

/**
 Pulse
 */
@property (nonatomic, strong) NSNumber *hr;

/**
 Year
 */
@property (nonatomic, strong) NSNumber *year;

/**
 Month
 */
@property (nonatomic, strong) NSNumber *month;

/**
 Date
 */
@property (nonatomic, strong) NSNumber *day;

/**
 Hour
 */
@property (nonatomic, strong) NSNumber *hour;

/**
 Minte
 */
@property (nonatomic, strong) NSNumber *minute;

/**
 the data is measured in diagnostic mode
 */
@property (nonatomic, strong) NSNumber *diagnostic;

/**
 the data is measured in night with diagnostic mode (ex. 4:00~12:00)
 */
@property (nonatomic, strong) NSNumber *AM;

/**
 the data is measured in morning with diagnostic mode (ex. 18:00~24:00)
 */
@property (nonatomic, strong) NSNumber *PM;

/**
 AFIb (If both detect Afib and IHB, only display Afib)
 */
@property (nonatomic, strong) NSNumber *AFIb;

@end

NS_ASSUME_NONNULL_END
