//
//  MicroLifeUserInfo.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/8.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeUserInfo : MicroLifeDataModel

/// BP's Device ID  Must be an 9-digit string 2-english string
@property (nonatomic, strong) NSString *bpmUserID;

/// PFM's Device ID  Must be an 9-digit string 2-english string
@property (nonatomic, strong) NSString *pfmUserID;

/// Weight's Device ID    Must be an 12-digit string  If the user is a guest, the userId should be set to @"000000000000"
@property (nonatomic, strong) NSString *weightUserID;

/// User No Current user, User1 = 1, User2 = 2, Guest = 3
@property (nonatomic, strong) NSNumber *userNo;

/// User age Must be between 18 and 80 years old, otherwise only weight value can be measured
@property (nonatomic, strong) NSNumber *age;

///  User height Range: 100cm ~ 220cm Unit: cm
@property (nonatomic, strong) NSNumber *height;

///  User weight (one decimal) Range: 20.0kg ~ 150.0kg Unit: kg
@property (nonatomic, strong) NSNumber *weight;

/// User gender
@property (nonatomic, assign) MicroLifeUserGender gender;

///  User's impedance value
///    1. When the user initializes, the resistance uses the default value of 0
///    2. Each time the user measures, the user's resistance (using the bodyFat.resistance value in the measurement result) needs to be updated and saved. When the user information is sent again later (for example, the app is restarted), the updated value needs to be updated. Resistance delivered to the scale to get accurate measurement results
@property (nonatomic, strong) NSNumber *resistance;

/// User's LED Display Settings
@property (nonatomic, assign) MicroLifeEBUnitType unitType;

/// User's exercise type
@property (nonatomic, assign) MicroLifeUserRoleType roleType;
@end

NS_ASSUME_NONNULL_END
