//
//  MicroLifeWS200.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2025/12/26.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDWS200) {
    CMDWS200WakeUpScale = 0x90,
    CMDWS200SleepScale = 0x91,
    CMDWS200SyncSystemClock = 0x98,
    CMDWS200QueryVersion = 0x9C,
    CMDWS200MeasurementResult = 0x9E,
    CMDWS200ReadHistorys = 0xA0,
    CMDWS200LowPower = 0xA4,
    CMDWS200NoMoreOfflineData = 0xA9,
    CMDWS200UpdateUserInfo = 0xB0,
    CMDWS200ClearAllUserInfo = 0xB1
};


NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWS200 : MicroLifeDevice


/// writeUserData
/// @param ID ID
/// @param age age
/// @param gender gender
/// @param height height
/// @param roleType roleType
/// @param weight weight
/// @param resistance resistance
- (void)writeUserData:(NSString *)ID Age:(NSInteger)age Gender:(MicroLifeUserGender)gender Height:(NSInteger)height RoleType:(MicroLifeUserRoleType)roleType Weight:(float)weight Resistance:(NSInteger)resistance;

/// read all history or current data
- (void)readHistorys;

/// Clear All Users
- (void)clearAllUsers;

/// disconnect
- (void)disconnect;

@end

NS_ASSUME_NONNULL_END
