//
//  MicroLifeWatchBPIncludeEachMeasurementData.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2023/2/21.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPIncludeEachMeasurementData : MicroLifeDataModel

/**
 Systolic avg
 */
@property (nonatomic, strong) NSNumber *SYSavg;

/**
 Diastolic avg
 */
@property (nonatomic, strong) NSNumber *DIAavg;

/**
 Pulse avg
 */
@property (nonatomic, strong) NSNumber *HRavg;

/**
 Year
 */
@property (nonatomic, strong) NSNumber *year;

/**
 Month
 */
@property (nonatomic, strong) NSNumber *month;

/**
 Date
 */
@property (nonatomic, strong) NSNumber *day;

/**
 Hour
 */
@property (nonatomic, strong) NSNumber *hour;

/**
 Minte
 */
@property (nonatomic, strong) NSNumber *minute;

/**
 the data detect with PAD  or Afib
 */
@property (nonatomic, strong) NSNumber *arr;

/**
 the data is measured in usual mode
 */
@property (nonatomic, strong) NSNumber *usual;

/**
 the data is measured in diagnostic mode
 */
@property (nonatomic, strong) NSNumber *diagnostic;

/**
 reserved bits
 */
@property (nonatomic, strong) NSNumber *AS;

/**
 the data is measured in night with diagnostic mode (ex. 4:00~12:00)
 */
@property (nonatomic, strong) NSNumber *AM;

/**
 the data is measured in morning with diagnostic mode (ex. 18:00~24:00)
 */
@property (nonatomic, strong) NSNumber *PM;

/**
 AFIb (If both detect Afib and IHB, only display Afib)
 */
@property (nonatomic, strong) NSNumber *AFIb;

/**
 Systolic 1
 */
@property (nonatomic, strong) NSNumber *sys1;

/**
 Diastolic 1
 */
@property (nonatomic, strong) NSNumber *dia1;

/**
 Pulse 1
 */
@property (nonatomic, strong) NSNumber *hr1;

/**
 Systolic 2
 */
@property (nonatomic, strong) NSNumber *sys2;

/**
 Diastolic 2
 */
@property (nonatomic, strong) NSNumber *dia2;

/**
 Pulse 2
 */
@property (nonatomic, strong) NSNumber *hr2;

/**
 Systolic 3
 */
@property (nonatomic, strong) NSNumber *sys3;

/**
 Diastolic 3
 */
@property (nonatomic, strong) NSNumber *dia3;

/**
 Pulse 3
 */
@property (nonatomic, strong) NSNumber *hr3;

/// measurement  times in usual mode
@property (nonatomic, strong) NSNumber *UTimes;

/**
 AFIb 1
 */
@property (nonatomic, strong) NSNumber *AF1;

/**
 AFIb 2
 */
@property (nonatomic, strong) NSNumber *AF2;

/**
 AFIb 3
 */
@property (nonatomic, strong) NSNumber *AF3;

@end

NS_ASSUME_NONNULL_END
