//
//  MicroLifeWatchBPSettingValues.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/7.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPSettingValues : MicroLifeDataModel

/**
 *  [WatchBP O3]The starting time of the first measurement time zone (valid range: 0~23)
 * */
@property (nonatomic, strong) NSNumber *ABPMStart;
/**
 *  [WatchBP O3]The end time of the first measurement time zone (valid range: 0~23)
 * */
@property (nonatomic, strong) NSNumber *ABPMEnd;
/**
 *  [WatchBP O3]The interval of the first measurement time zone (valid range: 5, 10, 15, 20, 30, and 60)
 * */
@property (nonatomic, assign) MeasurementTime ABPMInt_first;
/**
 *  [WatchBP O3]The interval of the second measurement time zone (valid range: 5, 10, 15, 20, 30, and 60)
 * */
@property (nonatomic, assign) MeasurementTime ABPMInt_second;
/**
 *  [WatchBP O3]the second time zone of CBP measurement true:disabled/false:enabled
 * */
@property (nonatomic, strong) NSNumber *CBP_zone2_meas_off;
/**
 *  [WatchBP O3]the first time zone of CBP measurement true:disabled/false:enabled
 * */
@property (nonatomic, strong) NSNumber *CBP_zone1_meas_off;
/**
 *  Beeper true:enabled/false:disabled
 * */
@property (nonatomic, strong) NSNumber *SW_SEL_silent;
/**
 *  [WatchBP O3]Hide(true)/Show(false) readings after measurement
 * */
@property (nonatomic, strong) NSNumber *SW_checkhide;
/**
 *  [WatchBP O3]The interval of the CBP first measurement time zone (valid range: 5, 10, 15, 20, 30, and 60)
 *  Note:  CBPInt_first should multiple time than ABPMInt_first.
 * */
@property (nonatomic, assign) MeasurementTime CBPInt_first;
/**
 *  [WatchBP O3]The interval of the CBP second measurement time zone (valid range: 5, 10, 15, 20, 30, and 60)
 *  Note:  CBPInt_second should multiple time than ABPMInt_second.
 * */
@property (nonatomic, assign) MeasurementTime CBPInt_second;

/// [WatchBP O3 (5 schedule)] ABPM Setting Values
@property (nonatomic, strong) NSMutableArray *settingValues;
/**
 *  [WatchBP O3 (5 schedule)]the second time zone of BP measurement true:disabled/false:enabled
 * */
@property (nonatomic, strong) NSNumber *BP_meas_off;
/**
 *  [WatchBP O3 (5 schedule)]the first time zone of CBP measurement true:disabled/false:enabled
 * */
@property (nonatomic, strong) NSNumber *CBP_meas_off;
/**
 [WatchBP Office]Highest inflation pressure of AUS mode
 
 Valid parameter: 0(not setting), 160, 180, 200, 220, 240
 
 The device inflates the cuff using fuzzy logic to proper cuff pressure; the Highest Inflation Pressure is considered as a safeguard pressure
 */
@property (nonatomic, assign) HIinfPressure AUS_HI_infPressure;
/**
 Highest inflation pressure of Auto mode
 
 Valid parameter: 0(not setting), 140, 160, 180, 200, 220, 240, 280
 
 The device inflates the cuff using fuzzy logic to proper cuff pressure; the Highest Inflation Pressure is considered as a safeguard pressure
 */
@property (nonatomic, assign) HIinfPressure HI_infPressure;

/// (valid range: 5,10,15,20,30,60, 255:diable
@property (nonatomic, assign) Interval Interval;

/**
 [WatchBP Office]Set Show readings during rest time in auto mode. true:hide/false:show
 */
@property (nonatomic, strong) NSNumber *SW_AUTO_hide;
/**
 [WatchBP Office]Set Show cuff pressure during deflation in AUS mode. true:hide/false:show
*/
@property (nonatomic, strong) NSNumber *SW_AUS_Hide;
/**
 [WatchBP Office]Set Average is include first memory data. true:is/false:is not
*/
@property (nonatomic, strong) NSNumber *SW_AVG_no_include_first;
/**
 [WatchBP Office]Set CBP measurement  true:enabled/false:disabled
*/
@property (nonatomic, strong) NSNumber *SW_CBP;
/**
 [WatchBP Office]Set AFib measurement  true:enabled/false:disabled
*/
@property (nonatomic, strong) NSNumber *SW_AFib;
/**
 [WatchBP Office]Set 12/24-hour clock true:12-hour/false:24-hour
*/
@property (nonatomic, strong) NSNumber *SW_AMPM;
/**
 [WatchBP Office]Set Pressure unit: true:Kpa/false:mmHg
*/
@property (nonatomic, strong) NSNumber *SW_Kpa;
/**
 [WatchBP Office]Rest time of auto mode
 
 Start countdown base on rest time before 1st measurement in auto mode.
 */
@property (nonatomic, strong) NSNumber *RestTime;
/**
 Interval time of auto mode
 
 Start countdown base on interval time before 2nd~6th measurement in auto mode.
 */
@property (nonatomic, strong) NSNumber *IntervalTime;
/**
 [WatchBP Office]AutoMeasureNumber: It’s number of measurements in auto mode.
 */
@property (nonatomic, strong) NSNumber *AutoMeasureNumber;

- (BOOL)checkSettingValues;

@end

NS_ASSUME_NONNULL_END
