//
//  LogManager.h
//  MicroLifeDeviceSDK-Dev
//
//  Created by willy.wu on 2019/12/19.
//  Copyright 2019 WiFi@MBP. All rights reserved.

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface LogManager : NSObject
//Print Log
@property (nonatomic,assign) BOOL showLog;

/**
 *  Get singleton instance
 *  @return Singleton instance
 */
+ (instancetype)sharedInstance;

#pragma mark - Method

/// show Log
/// @param showLog showLog
- (void)showLog:(BOOL)showLog;

/// set Password
/// @param pw Password
- (void)setPW:(NSString *)pw;

/// set AES
/// @param aes aes password
- (void)setAES:(NSString *)aes;

/// add Log File
/// @param url url
- (void)addLogFile:(NSURL *)url;

- (void)addLogFiles:(NSArray<NSURL *> *)urls;

/// set Log Max Save Day[7Day]
/// @param logMaxSaveDay logMaxSaveDay
- (void)setMaxSaveDay:(NSInteger)logMaxSaveDay;

/**
 *  Write log
 *
 *  @param module Module
 *  @param format Log information, dynamic parameters
 */
- (void)logInfo:(NSString *)module
         logStr:(NSString *)format, ...;

/**
 *  Write log with a pre-formatted message
 *
 *  @param module Module
 *  @param message The formatted log message
 */
- (void)logInfo:(NSString *)module
        message:(NSString *)message;

/**
 *  Empty expired logs
 */
- (void)clearExpiredLog;

/**
 *  Generate support information dictionary for email composition
 *  產生用於郵件編寫的支援資訊字典
 *
 *  @param ID         Support ticket ID / 支援票據ID
 *  @param type       Issue type or category / 問題類型或分類
 *  @param info       Additional information about the issue / 關於問題的額外資訊
 *  @param app_Name   Application name / 應用程式名稱
 *  @param app_Version Application version / 應用程式版本
 *  @param user_Name  User identifier / 使用者識別碼
 *  @param emails     Custom recipient email addresses, if nil uses default / 自訂收件人郵件地址，若為nil則使用預設值
 *
 *  @return Dictionary containing email composition data or nil if compression fails
 *          包含郵件編寫資料的字典，若壓縮失敗則回傳nil
 *
 *  Dictionary keys / 字典鍵值:
 *  - "subject": Email subject line / 郵件主旨
 *  - "body": Email body content / 郵件內容
 *  - "toRecipients": Array of primary recipients / 主要收件人陣列
 *  - "ccRecipients": Array of CC recipients / 副本收件人陣列
 *  - "logZipData": Compressed log data (NSData) / 壓縮日誌資料
 *  - "logZipFileName": Log zip file name / 日誌壓縮檔名稱
 */
- (NSDictionary * _Nullable)supportInfoWith:(NSInteger)ID
                                       Type:(NSString *)type
                                       Info:(NSString*)info
                                    AppName:(NSString*)app_Name
                                 AppVersion:(NSString*)app_Version
                                       User:(NSString *)user_Name
                                     Emails:(NSArray * _Nullable)emails;

/// Send log
/// @param info <#info description#>
/// @param app_Name <#app_Name description#>
/// @param app_Version <#app_Version description#>
/// @param user_Name <#user_Name description#>
- (void)sendSupportMailWith:(NSInteger)ID
                       Type:(NSString *)type
                       Info:(NSString*)info
                    AppName:(NSString*)app_Name
                 AppVersion:(NSString*)app_Version
                       User:(NSString *)user_Name;

/// Send log
/// @param info <#info description#>
/// @param app_Name <#app_Name description#>
/// @param app_Version <#app_Version description#>
/// @param user_Name <#user_Name description#>
/// @param emails <#emails description#>
- (void)sendSupportMailWith:(NSInteger)ID
                       Type:(NSString *)type
                       Info:(NSString*)info
                    AppName:(NSString*)app_Name
                 AppVersion:(NSString*)app_Version
                       User:(NSString *)user_Name
                     Emails:(NSArray *)emails;

/// Get compressed log file Path
- (NSString *)getLogZipPath;

/// Get compressed log file
/// @param block BOOL success, NSString *logZipPath
- (void)getLogZip:(void (^)(BOOL success, NSString *logZipPath))block;

/// Get log file paths
- (NSArray *)getLogFilePaths;
@end

NS_ASSUME_NONNULL_END
