//
//  MicroLife4GBP.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/7.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger , CMD4G) {
    CMD4GReadHistorys = 0x00,
    CMD4GClearAllHistorys = 0x03,
    CMD4GDisconnect = 0x04,
    CMD4GReadUserAndVersionData = 0x05,
    CMD4GWriteUser = 0x06,
    CMD4GReadLastData = 0x07,
    CMD4GClearLastData = 0x08,
    CMD4GReadDeviceInfo = 0x0B,
    CMD4GReadDeviceTime = 0x0C,
    CMD4GSyncTiming = 0x0D,
    CMD4GCheckTransmit = 0x0E,
    CMD4GReadSerialNumber = 0x0F,
    CMD4GReplyACK = 0x81,
    CMD4GReplyNACK = 0x91,
    CMD4GReplyNullACK = 0x92
};

@interface MicroLife4GBP : MicroLifeDevice

/// read all history or current data from bpm
-(void)readHistorys;

/// clear all history data from bpm
- (void)clearAllHistorys;

/// disconnect
- (void)disconnect;

/// read user id and version data from bpm
- (void)readUserAndVersionData;

/// write a new user id & age
/// @param ID userID (Must be a 9-digit string 2-english string)
/// @param age age
- (void)writeUserData:(NSString *)ID Age:(NSInteger)age;

/// read Device information
- (void)readDeviceInfo;

///  Read device Time from BPM
- (void)readDeviceTime;

/// Synchronize device time
- (void)syncTiming;

/// Check Transmit
///Note:   protocolID should be greater than 0x0A0D
- (BOOL)checkTransmit;

/// Read last 1 data from the BPM  [Attention] will not respond!
/// Note:   protocolID should be greater than 0x0A0E
- (BOOL)readLastData;

/// Clear last 1 data of the BPM [Attention] will not respond!
/// Note:   protocolID should be greater than 0x0A0E
- (BOOL)clearLastData;

///Read device SN from BPM
///Note:   protocolID should be greater than 0x0A0D
- (BOOL)readSerialNumber;

@end

NS_ASSUME_NONNULL_END
