//
//  MicroLifeBGM700.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2024/5/31.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger , CMDBGM700) {
    CMDBGM700QueryMachineFunction = 0x3000,
    CMDBGM700QueryBloodGlucoseDatas = 0xA100,
    CMDBGM700DownloadBloodGlucoseData = 0xA200,
    CMDBGM700QueryUricAcidDatas = 0xA300,
    CMDBGM700DownloadUricAcidData = 0xA400,
    CMDBGM700QueryCholesterolDatas = 0xA500,
    CMDBGM700DownloadCholesterolData = 0xA600,
    CMDBGM700QueryBloodKetoneDatas = 0xA700,
    CMDBGM700DownloadBloodKetoneData = 0xA800,
    CMDBGM700QueryGKIDatas = 0xA900,
    CMDBGM700DownloadGKIData = 0xAA00,
    CMDBGM700QueryLactateDatas = 0xAB00,
    CMDBGM700DownloadLactateData = 0xAC00,
    CMDBGM700QueryHemeDatas = 0xAD00,
    CMDBGM700DownloadHemeData = 0xAE00
};

/**
 PARAM

 - PARAMNone: 無
 - PARAMAll: 所有數據
 - PARAMLessSN1: 小於等於 SN1
 - PARAMMoreSN1: 大於等於 SN1
 - PARAMIncludeSN12: SN1到SN2之間 (包含)
 */
typedef NS_ENUM(NSInteger, PARAM) {
    PARAMNone = 0x0000,
    PARAMAll = 0x1100,
    PARAMLessSN1 = 0x1200,
    PARAMMoreSN1 = 0x1300,
    PARAMIncludeSN12 = 0x1400
};

@interface MicroLifeBGM700 : MicroLifeDevice

///  Query blood glucose machine function
- (void)QueryMachineFunction;

/// Query blood glucose data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryBloodGlucoseDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download Blood Glucose Data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadBloodGlucoseData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Query uric acid data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryUricAcidDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download Uric Acid Data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadUricAcidData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Query cholesterol data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryCholesterolDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download Cholesterol Data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadCholesterolData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Query blood ketone data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryBloodKetoneDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download blood ketone data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadBloodKetoneData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Query GKI data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryGKIDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download GKI data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadGKIData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Query Lactate Data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryLactateDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download lactate data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadLactateData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Query heme data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)QueryHemeDatas:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

/// Download Heme Data
/// - Parameters:
///   - PARAM: <#PARAM description#>
///   - SN1: <#SN1 description#>
///   - SN2: <#SN2 description#>
- (void)DownloadHemeData:(PARAM)PARAM SN1:(NSInteger)SN1 SN2:(NSInteger)SN2;

@end

NS_ASSUME_NONNULL_END
