//
//  MicroLifeBGM800.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2024/5/31.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger , CMDBGM800) {
    CMDBGM800ReadDeviceName = 0x01,
    CMDBGM800ReadFWVersion = 0x02,
    CMDBGM800BLEStatus = 0x20,
    CMDBGM800ReadData = 0x35,
    CMDBGM800ReadNewData = 0x3500,
    CMDBGM800ReadHistorysData = 0x3550,
    CMDBGM800ReadLastData = 0x3501,
    CMDBGM800ReadDataLength = 0x3502,
    CMDBGM800Disconnect = 0x36,
    CMDBGM800ReadDateTime = 0x45,
    CMDBGM800UploadMeterData = 0x50,
    CMDBGM800WriteDeviceName = 0x51,
    CMDBGM800MeterDataTransmissionStatus = 0x52,
    CMDBGM800CommunicationMode = 0x53,
    CMDBGM800BLEParingMode = 0x60,
    CMDBGM800MeterAuthorization = 0x61,
    CMDBGM800ParingRequest = 0x70,
    CMDBGM800ParingTimeOut = 0x71
};

@interface MicroLifeBGM800 : MicroLifeDevice
#pragma mark - CMD

/// read Device Name
- (void)readDeviceName;

/// read FW Version
- (void)readFWVersion;

/// get BLEStatus
- (void)getBLEStatus;

/// read Last Data
- (void)readLastData;

/// read Data form counts
/// @param counts counts
- (void)readData:(NSInteger)counts;

/// read Data Length
- (void)readDataLength;

/// upload Meter Data
- (void)uploadMeterData;

/// disconnect
- (void)disconnect;

/// read DateTime
- (void)readDateTime;

/// write Device Name
/// @param name name
- (void)writeDeviceName:(NSString *)name;

/// get Meter Data Transmission Status
- (void)getMeterDataTransmissionStatus;

/// get Communication Mode
- (void)getCommunicationMode;

/// set BLE ParingMode
- (void)setBLEParingMode;

/// set Meter Authorization
- (void)setMeterAuthorization;

/// set Paring Request
- (void)setParingRequest;

/// set Paring TimeOut
- (void)setParingTimeOut;
@end

NS_ASSUME_NONNULL_END
