//
//  MicroLifeBGM800MeasureData.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2024/5/31.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeBGM800MeasureData : MicroLifeDataModel

@property (nonatomic, strong) NSNumber *recordCounts;

@property (nonatomic, strong) NSNumber *recordIndex;

/// Unit, 1: mg/L, 0: mmol/L
@property (nonatomic, strong) NSNumber *unit;

/// Check Mark, 1: Data is marked, 0: Data doesn't marked
@property (nonatomic, strong) NSNumber *mark;

@property (nonatomic, strong) NSNumber *year;
@property (nonatomic, strong) NSNumber *month;
@property (nonatomic, strong) NSNumber *day;

@property (nonatomic, strong) NSNumber *hour;
@property (nonatomic, strong) NSNumber *minute;

/// Event, 1: Data is marked, 0: Data doesn't marked
@property (nonatomic, strong) NSNumber *event;

/// Meal Type, 10: After Meal, 01: Before Meal, 00: No Meal
@property (nonatomic, strong) NSNumber *mealType;

/// Ctl, 1: Control Solution, 0: Blood
@property (nonatomic, strong) NSNumber *ctl;

@property (nonatomic, strong) NSNumber *result;

@end

NS_ASSUME_NONNULL_END
