//
//  MicroLifeBloodPressureCurrentAndMData.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/8.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeBloodPressureCurrentAndMData : MicroLifeDataModel

/**
 Systolic
 */
@property (nonatomic, strong) NSNumber *sys;

/**
 Diastolic
 */
@property (nonatomic, strong) NSNumber *dia;

/**
 Pulse
 */
@property (nonatomic, strong) NSNumber *hr;

/**
 Year
 */
@property (nonatomic, strong) NSNumber *year;

/**
 Month
 */
@property (nonatomic, strong) NSNumber *month;

/**
 Date
 */
@property (nonatomic, strong) NSNumber *day;

/**
 Hour
 */
@property (nonatomic, strong) NSNumber *hour;

/**
 Minte
 */
@property (nonatomic, strong) NSNumber *minute;

/**
 3G detection mode 0:BP_Single_MOD 3:BP_MAM_MODE+ SW AFib ON
 4G detection mode 0:BP_Single_MOD 1:BP_Single_MODE+SW AFib ON 2:BP_MAM_MODE 3:BP_MAM_MODE+ SW AFib ON
 */
@property (nonatomic, strong) NSNumber *MAM;

/**
 the data detect with PAD  or Afib
 */
@property (nonatomic, strong) NSNumber *arr;

//4G
/**
 Whether the wristband is tight
 3G detection mode 2: No detection
 4G detection mode 0: No tightness 1: There is tightness
 */
@property (nonatomic, strong) NSNumber *cuffokr;

/**
 IHB
 */
@property (nonatomic, strong) NSNumber *IHB;

/**
 AFIb (If both detect Afib and IHB, only display Afib)
 */
@property (nonatomic, strong) NSNumber *AFIb;

//5G
@property (nonatomic, strong) NSNumber *MAP;

@property (nonatomic, strong) NSNumber *second ;

@property (nonatomic, strong) NSNumber *temperature;

@property (nonatomic, strong) NSNumber *pulAmp;

@end

NS_ASSUME_NONNULL_END
