//
//  MicroLifeDeviceInfo.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/8.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeDeviceInfo : MicroLifeDataModel

@property (nonatomic, strong) NSString *macAddress;

@property (nonatomic, strong) NSNumber *workMode;

@property (nonatomic, strong) NSNumber *batteryVoltage;

@property (nonatomic, strong) NSNumber *year;

@property (nonatomic, strong) NSNumber *month;

@property (nonatomic, strong) NSNumber *day;

@property (nonatomic, strong) NSNumber *hour;

@property (nonatomic, strong) NSNumber *minute;

@property (nonatomic, strong) NSNumber *second;

@property (nonatomic, strong) NSNumber *maxUser;

@property (nonatomic, strong) NSNumber *maxMemory;

@property (nonatomic, strong) NSNumber *optionIHB;

@property (nonatomic, strong) NSNumber *optionPAD;

@property (nonatomic, strong) NSNumber *optionAfib;

@property (nonatomic, strong) NSNumber *optionCBP;

@property (nonatomic, strong) NSNumber *optionMAM;

@property (nonatomic, strong) NSNumber *optionSingleCycleAfib;

@property (nonatomic, strong) NSNumber *optionAmbientT;

@property (nonatomic, strong) NSNumber *optionTubeless;

@property (nonatomic, strong) NSNumber *optionDeviceID;

@property (nonatomic, strong) NSString *FWName;

@property (nonatomic, strong) NSString *FWDate;

@property (nonatomic, strong) NSNumber *historyMeasurementNumber;

@property (nonatomic, strong) NSNumber *userNumber;

@property (nonatomic, strong) NSNumber *MAMState;

@property (nonatomic,strong) NSString *connectType;

@property (nonatomic, strong) NSNumber *measurementTimes;

@property (nonatomic, strong) NSMutableDictionary *errHappendTimes;

@property (nonatomic, strong) NSNumber *isTimeReady;

@property (nonatomic, strong) NSNumber *openNocturnal;

@property (nonatomic, strong) NSNumber *optionDiagnosticModeAFib;

@property (nonatomic, strong) NSNumber *openNoUsualModeAFib;

/// Can change the night mode setting
@property (nonatomic, strong) NSNumber *openNocturnalMode;

@property (nonatomic, strong) NSNumber *openBPtype;

///  Protocol Version
@property (nonatomic, strong) NSString *protocolVersion;

///  Arr Name: Display arrhythmia name in software
///  Arr Name    Define
///  0x00        Don’t Display .
///  0x01        Display IHB
///  0x02        Display PAD
@property (nonatomic, strong) NSNumber *arrName;

///  Current Mode: Display Device current measurement mode
///  Current Mode    Define
///  0x00            Usual mode / BP_Single_MODE
///  0x01            Diagnostic mode / BP_Single_MODE + SW Afib ON
///  0x02            Usual mode / BP_MAM_MODE
///  0x03            Diagnostic mode / BP_MAM_MODE + SW Afib ON
@property (nonatomic, strong) NSNumber *currentMode;

/// measure serial namber
@property (nonatomic, strong) NSString *sn;

/// BT Module Name
@property (nonatomic, strong) NSString *BTModuleName;

/// Oxygen saturation min
@property (nonatomic, strong) NSNumber *minSPO;

/// Oxygen saturation Max
@property (nonatomic, strong) NSNumber *maxSPO;

/// Pulse rate min
@property (nonatomic, strong) NSNumber *minPlus;

/// Pulse rate Max
@property (nonatomic, strong) NSNumber *maxPlus;

/// Rest time: (RestIntervalTime) It’s interval before 1st measurement.
@property (nonatomic, strong) NSNumber *restTime;

/// Interval time: (RestIntervalTime) It’s interval between each measurement.
@property (nonatomic, strong) NSNumber *intervalTime;

/// Exclude average: (ExcludeAverage)
/// 0: average all measurements
/// 1: average excludes 1st measurement
@property (nonatomic, strong) NSNumber *excludeAverage;

/// OffsetYear: (Default = 21)
/// This parameter affects the calculated formula for stored data:
/// Year = 2000+ Y04*16 + YEAR ＋OffsetYear
@property (nonatomic, strong) NSNumber *offsetYear;

/// SW_Afib enable the Afib function. (this setting is valid with the Afib option enable in “BPMSetting2”.)
@property (nonatomic, strong) NSNumber *SW_Afib;

@property (nonatomic, strong) NSNumber *connection;
@property (nonatomic, strong) NSNumber *bonding;
@property (nonatomic, strong) NSNumber *weakupMode;

/// Pulse amp type:  0XFF: N/A   Pluse amp type (1~254)
@property (nonatomic, strong) NSNumber *pulseampType;

/// Device AmbientT:  0XFF: N/A  AmbientT range (10.00~40.00 ℃)
@property (nonatomic, strong) NSNumber *deviceAmbientT;

/**
 * Weight unit (MicroLifeEBUnitType)
 */
@property (nonatomic, strong) NSNumber *weightUnit;

/// ble Ver
@property (nonatomic, strong) NSNumber *bleVer;

/// scale Ver
@property (nonatomic, strong) NSString *scaleVer;

/// coefficient Ver
@property (nonatomic, strong) NSNumber *coefficientVer;

/// arithmetic Ver
@property (nonatomic, strong) NSNumber *arithmeticVer;

/// Peakflow Meter Best Value
@property (nonatomic, strong) NSNumber *bestValue;

/// Peakflow Meter High Value
@property (nonatomic, strong) NSNumber *highValue;

/// Mode = 0 : Normal mdoe
/// Mode = 1 : Waveform mode
@property (nonatomic, strong) NSNumber *waveformMode;

/// Data = 0 : Have not new data
/// Data = 1 : Have new data
@property (nonatomic, strong) NSNumber *haveNewData;

//Support Blood sugar
@property (nonatomic, strong) NSNumber *openBloodSugar;

//Support Uric acid
@property (nonatomic, strong) NSNumber *openUricAcid;

//Support Cholesterol
@property (nonatomic, strong) NSNumber *openCholesterol;

//Support Blood ketones
@property (nonatomic, strong) NSNumber *openBloodKetones;

//Support Heme
@property (nonatomic, strong) NSNumber *openHeme;

//Support Lactic acid
@property (nonatomic, strong) NSNumber *openLacticAcid;

//Support GKI
@property (nonatomic, strong) NSNumber *openGKI;


@end

NS_ASSUME_NONNULL_END
