//
//  MicroLifeECG.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/19.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger , CMDECG) {
    CMDECGReadECGRawData = 0x70,
    CMDECGReadECGHistoryRawData = 0x72,
    CMDECGReadDataAndList = 0x00,
    CMDECGReadECGDataByIndex = 0x01,
    CMDECGClearTheAllHistoryData = 0x03,
    CMDECGDisconnect = 0x04,
    CMDECGReadUserIDAndVersionData = 0x05,
    CMDECGWriteNewUserID = 0x06,
    CMDECGReadLastData = 0x07,
    CMDECGReadDeviceIDAndInfo = 0x0B,
    CMDECGReadDeviceTime = 0x0C,
    CMDECGWriteDeviceTime = 0x0D,
    CMDECGAskDeviceDisplayTransmitAnimationEnd = 0x0E,
    CMDECGReadSerialNumber = 0x0F,
    CMDECGReadDeviceFunctionSettingValues = 0x10,
    CMDECGReadECGAllSettingValues = 0x12,
    CMDECGReadDeviceUserSettingValues = 0x14,
    CMDECGwriteDeviceUserSettingValues = 0x15,
    CMDECGReadDeviceCurrentStatus = 0x20,
    CMDECGStartECGMeasurement = 0x25,
    CMDECGStopECGMeasurement = 0x26,
    CMDECGReplyACK = 0x81,
    CMDECGReplyNACK = 0x91,
    CMDECGReplyNullACK = 0x92
};

@interface MicroLifeECG : MicroLifeDevice

/// Read data and list from device
- (void)readAllHistorys;

/// Send ECG raw data by index to APP
/// @param index Valid memory index rule:Check by command 00h which reply condition = “BP_ECG (31)” or “ECG (32)” and ECG code = “1: succeed measurement”.
/// @param transmitRate Transmit Rate:Valid range: 1~2 1:256Hz 2:512Hz
- (void)readECGDataWithIndex:(NSInteger)index TransmitRate:(TransmitRate)transmitRate;

/// Clear all history data of the DEVICE
- (void)clearAllHistorys;

/// Disconnect the Bluetooth
- (void)disconnect;

/// Read user ID and version data from DEVICE
- (void)readUserAndVersionData;

/// Write a new user ID from DEVICE
/// @param ID user ID
/// @param age age
- (void)writeUserData:(NSString *)ID Age:(NSInteger)age;

/// Read last 1 data from the BPM
/// ※This command is only used while device-status is MicroLifeECGStatusDetectNewBloodPressureData = 0x02 or MicroLifeECGStatusDetectNewBloodPressureDataWaitECGTrigger = 0x03 (detect new blood pressure data).
- (BOOL)readLastData;

/// Read device ID and info from DEVICE
- (void)readDeviceInfo;

///  Read device Time from BPM
- (void)readDeviceTime;

/// Write device Time to BPM
- (void)writeDeviceTime;

/// ask device display transmit-end animation
/// If any command succeeds, LCD displays  icon animation (flash at 1Hz).
/// Send this command to display transmit-end status ( flash 3 times)
- (void)askDeviceDisplayTransmitEndAnimation;

/// Read serial number from DEVICE
- (void)readSerialNumber;

/// Read device function setting values from device
- (void)readFunctionSettingValue;

/// Read device user setting values from device
- (void)readSettingValues;

/// Write device user setting values to the device.
///
/// @param SW_BT Controls Bluetooth visibility (Airplane mode). If set via Bluetooth, the device will become effective after disconnection. To re-enable, the user must use the device's physical setting mode.
/// @param SW_BPplusECG 0: Only measure blood pressure. 1: After blood pressure measurement, automatically trigger ECG if arrhythmia is detected.
/// @param SW_max3003_filter 0: Turn off frontend filter. 1: Turn on frontend filter.
/// @param SW_turnOff_leaddetect 0: Enable lead detection (Default). 1: Turn off lead detection (Factory use only).
/// @param SW_continued_ECG 0: Standard ECG measurement (30s or 60s), raw data stored to flash. 1: Unlimited measurement time for testing; raw data is NOT stored.
/// @param SW_BeepOn Controls the device buzzer/beep sound. YES: On, NO: Off.
/// @param SW_Afib 0: Disable Afib detection during BP measurement. 1: Enable Afib detection during BP measurement.
/// @param MAMRest The rest time between MAM measurements (e.g., enum value for countdown time).
/// @param length ECG measurement duration. 0: N/A, 1: 30s, 2: 60s. (Factory test modes: 9 = 540s, 31 = 1830s).
/// @param MAMInterval The interval setting for MAM mode (e.g., 15 or 60).
- (void)writeSettingValuesWithSW_BT:(BOOL)SW_BT
                       SW_BPplusECG:(BOOL)SW_BPplusECG
                  SW_max3003_filter:(BOOL)SW_max3003_filter
               SW_turnOff_leaddetect:(BOOL)SW_turnOff_leaddetect
                   SW_continued_ECG:(BOOL)SW_continued_ECG
                          SW_BeepOn:(BOOL)SW_BeepOn
                            SW_Afib:(BOOL)SW_Afib
                            MAMRest:(MAMRest)MAMRest
                             length:(SsampleTime)length
                        MAMInterval:(MAMInterval)MAMInterval;

/// Read Device Status
- (void)readDeviceStatus;

/// Start ECG measurement
- (void)startECGMeasurement;

/// Stop ECG measurements
- (void)stopECGMeasurements;

#pragma mark - Regular command for factory used
- (void)writeFunctionSettingValuesWithFunc_Set1:(NSInteger)Func_Set1 Func_Set2:(NSInteger)Func_Set2 Func_Set3:(NSInteger)Func_Set3 TotalUserNumber:(NSInteger)TotalUserNumber MemorySet:(NSInteger)MemorySet OldPreDeflateValue:(NSInteger)OldPreDeflateValue YEARINIT:(NSInteger)YEARINIT Func_Set4:(NSInteger)Func_Set4 Trafficlightlevel:(NSInteger)Traffic_light_level BT_ModuleName:(NSString *)BT_ModuleName Fun_Sel_ValveType:(NSInteger)Fun_Sel_ValveType ECG_Cal_Gain:(NSInteger)ECG_Cal_Gain;

@end

NS_ASSUME_NONNULL_END
