//
//  MicroLifeECGFunctionSettingValues.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/25.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeECGFunctionSettingValues : MicroLifeDataModel

/// Cuff Position Detection Feature
/// @discussion Controls the CuffOK feature for monitoring cuff position
/// @note 0: CuffOK feature disabled
/// @note 1: CuffOK feature enabled - checks cuff position before measurement
@property (nonatomic, strong) NSNumber *Fun_SEL_CUFFOK;

/// Time Display Format
/// @discussion Controls the time display format (12-hour or 24-hour)
/// @note 0: 12-hour format (AM/PM)
/// @note 1: 24-hour format (00:00-23:59)
@property (nonatomic, strong) NSNumber *Fun_SEL_24hr;

/// Buzzer Feature
/// @discussion Controls the device's sound notification system
/// @note 0: Buzzer disabled - device operates silently
/// @note 1: Buzzer enabled - provides sound alerts for measurement start, completion, and error conditions
@property (nonatomic, strong) NSNumber *Fun_SEL_Beep;

/// MAM Measurement Feature
/// @discussion Controls the Multiple Average Mode (MAM) measurement functionality
/// @note 0: MAM feature disabled - single measurement mode
/// @note 1: MAM feature enabled - takes multiple measurements for averaging
@property (nonatomic, strong) NSNumber *Fun_SEL_MAM;

/// Smart MAM Feature
/// @discussion Controls the Smart Multiple Average Mode measurement functionality
/// @note 0: Smart MAM feature disabled
/// @note 1: Smart MAM feature enabled - advanced multiple measurement averaging
@property (nonatomic, strong) NSNumber *Fun_SEL_SmartMAM;

/// MAM Mode Selection
/// @discussion Controls the type of MAM measurement mode
/// @note 0: MAM weight feature enabled
/// @note 1: MAM light feature enabled
@property (nonatomic, strong) NSNumber *Fun_SEL_MAMLIGHT;

/// Irregular Heartbeat Detection
/// @discussion Controls the Irregular Heartbeat (IHB) detection feature
/// @note 0: IHB detection disabled
/// @note 1: IHB detection enabled - monitors for irregular heartbeats
@property (nonatomic, strong) NSNumber *Fun_SEL_IHB;

/// MAM AFib Detection
/// @discussion Controls the Atrial Fibrillation detection in MAM mode
/// @note 0: MAM AFib detection disabled
/// @note 1: MAM AFib detection enabled - checks for AFib during MAM measurements
@property (nonatomic, strong) NSNumber *Fun_SEL_MAMAFib;

/// Single Cycle AFib Detection
/// @discussion Controls the Atrial Fibrillation detection in single measurement mode
/// @note 0: Single cycle AFib detection disabled
/// @note 1: Single cycle AFib detection enabled - checks for AFib during single measurements
@property (nonatomic, strong) NSNumber *Fun_SEL_SingleAFib;

/// Traffic Light LCD Display Feature
/// @discussion Controls the traffic light indicator on LCD display
/// @note 0: Traffic light LCD feature disabled
/// @note 1: Traffic light LCD feature enabled - provides visual indicators
@property (nonatomic, strong) NSNumber *Fun_SEL_TrafficlightLCD;

/// Traffic Light LCD Display Type
/// @discussion Controls the behavior mode of traffic light LCD display
/// @note 0: Independent mode - discrete color indicators
/// @note 1: Progressive mode - continuous color transition
@property (nonatomic, strong) NSNumber *Fun_SEL_TrafficlightLCD_TYPE;

/// My Blood Pressure Feature
/// @discussion Controls the personalized blood pressure monitoring feature
/// @note 0: MY BP feature disabled
/// @note 1: MY BP feature enabled - tracks personal BP patterns
@property (nonatomic, strong) NSNumber *Fun_SEL_MYBP;

/// My Check Feature
/// @discussion Controls the measurement verification system
/// @note 0: MY Check feature disabled
/// @note 1: MY Check feature enabled - validates measurement accuracy
@property (nonatomic, strong) NSNumber *Fun_SEL_MYCheck;

/// All Measurements Average Feature
/// @discussion Controls the comprehensive averaging functionality
/// @note 0: All average feature disabled
/// @note 1: All average feature enabled - calculates overall measurement averages
@property (nonatomic, strong) NSNumber *Fun_SEL_AllMEAN;

/// LCD Display Mode
/// @discussion Controls the LCD segment display pattern
/// @note 0: Display LCD segments based on active features only
/// @note 1: Display all LCD segments (factory testing mode)
@property (nonatomic, strong) NSNumber *Fun_SEL_LCDShowAll;

/// My BP First Day Data Inclusion
/// @discussion Controls whether to include first day data in My BP calculations
/// @note 0: Exclude first day measurements from My BP calculations
/// @note 1: Include first day measurements in My BP calculations
@property (nonatomic, strong) NSNumber *Fun_SEL_MYBP_AVGday1;

/// Total User Count
/// @discussion Stores the total number of users registered in the device
/// @note Represents the maximum number of users that can store their measurements
@property (nonatomic, strong) NSNumber *TotalUserNumber;

/// Memory Configuration
/// @discussion Controls the device's memory storage settings
/// @note Configures how measurement data is stored and managed
@property (nonatomic, strong) NSNumber *MemorySet;

/// Previous Deflation Value
/// @discussion Stores the previous deflation pressure value
/// @note Used for optimizing subsequent measurements based on historical data
@property (nonatomic, strong) NSNumber *OldPreDeflateValue;

/// Initial Year Setting
/// @discussion Stores the initial year setting for the device
/// @note Used as reference point for date calculations
@property (nonatomic, strong) NSNumber *YEARINIT;

/// RS232 Serial Communication Feature
/// @discussion Controls the RS232 serial data transmission feature for factory testing
/// @note 0: RS232 feature disabled
/// @note 1: Enables test data transmission through UART2 (factory use only)
@property (nonatomic, strong) NSNumber *Fun_SEL_RS232;

/// Factory Continuous Measurement Mode
/// @discussion Controls the automatic continuous blood pressure measurement mode for factory testing
/// @note 0: Factory measurement mode disabled
/// @note 1: Enables automatic continuous BP measurements (factory use only)
@property (nonatomic, strong) NSNumber *Fun_SEL_FacMeasure;

/// Traffic Light Level Setting
/// @discussion Controls the threshold levels for traffic light indicators
/// @note Determines the blood pressure ranges for green, yellow, and red indicators
@property (nonatomic, strong) NSNumber *TrafficLightLevel;

/// Bluetooth Module Name
/// @discussion Stores the name of the Bluetooth module
/// @note Used for device identification during Bluetooth pairing
@property (nonatomic, strong) NSString *BTModuleName;

/// Valve Type Selection
/// @discussion Controls the type of valve mechanism used in the device
/// @note Determines the deflation behavior during measurements
@property (nonatomic, strong) NSNumber *FunSelValveType;

/// ECG Calibration Gain
/// @discussion Controls the calibration factor for ECG voltage measurements
/// @note Normal range: 90-110% (100 = 100% standard calibration)
@property (nonatomic, strong) NSNumber *ECGCalGain;

@end

NS_ASSUME_NONNULL_END
