//
//  MicroLifeECGInformationData.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/22.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeECGInformationData : MicroLifeDataModel

#pragma mark - CMD 01-00 (ACK Reply)

/// Memory Index (1~40)
@property (nonatomic, strong) NSNumber *index;

/// Transmit Rate (512Hz)
@property (nonatomic, assign) TransmitRate transmitRate;


#pragma mark - CMD 01-01 (ECG Information)

/// raw data size：It’s the byte number of raw data (512*3 *30 or 512*3 *60)
@property (nonatomic, strong) NSNumber *rawDataSize;

/// checksum：Calculate checksum for all raw data
@property (nonatomic, strong) NSNumber *checksum;

/// Sample rate：0:128, 1:256, 2:512 sps
@property (nonatomic, assign) SampleRate sampleRate;

/// Length (sample time)：0:N/A, 1:30 seconds, 2:60seconds
@property (nonatomic, assign) SsampleTime length;

/// AD Resolution (bits)：18 bits
@property (nonatomic, strong) NSNumber *ADResolution;

/// Supply power (Voltage * 10)
@property (nonatomic, strong) NSNumber *supplyPower;

/// sw offset (reserved)
@property (nonatomic, strong) NSNumber *swOffset;

/// sw invert (reserved)
@property (nonatomic, strong) NSNumber *swInvert;

/// sw gain adjustment：100= 100% (Mapped from ECG_Cal_Gain)
@property (nonatomic, strong) NSNumber *swGainAdjustment;

/// sw filter ：0:Off, 1:ON (Mapped from HW filter)
@property (nonatomic, strong) NSNumber *swFilter;

#pragma mark - Date Time

/// Start Year
@property (nonatomic, strong) NSNumber *year;

/// Start Month
@property (nonatomic, strong) NSNumber *month;

/// Start Date
@property (nonatomic, strong) NSNumber *day;

/// Start Hour
@property (nonatomic, strong) NSNumber *hour;

/// Start Minte
@property (nonatomic, strong) NSNumber *minute;

/// Start Second
@property (nonatomic, strong) NSNumber *second;

#pragma mark - Legacy / Reserved (Not in new protocol)

/// Average RR (BPM)：Reserved for future function
@property (nonatomic, strong) NSNumber *averageRR;

/// RR number (BPM)：Reserved for future function
@property (nonatomic, strong) NSNumber *rrNumber;

/// RR array (BPM)：If 25+RR number >256, auto remove oldest RR and store recent RR-interval.
@property (nonatomic, strong) NSNumber *rrArray;

@end

NS_ASSUME_NONNULL_END
