//
//  MicroLifeECGSampleData.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/25.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger, VoltageBitType) {
    VoltageType16bit,
    VoltageType18bit,
};

typedef NS_ENUM(NSInteger, VoltageGainType) {
    VoltageType20vv,
    VoltageType160vv,
};

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeECGSampleData : MicroLifeDataModel

/// Voltage Bit Type
@property (nonatomic, assign) VoltageBitType voltageBitType;

/// Voltage Gain Type
@property (nonatomic, assign) VoltageGainType voltageGainType;

/// ECG (Spec voltage (mV))
@property (nonatomic, strong) NSNumber *ECG;

/// ECG RAW Data 
@property (nonatomic, strong) NSNumber *ECGr;

/// ETAG
@property (nonatomic, strong) NSNumber *ETAG;

/// PTAG
@property (nonatomic, strong) NSNumber *PTAG;

- (void)analysis:(MicroLifeDeviceType)deviceType CMD:(NSInteger)CMD Data:(id)value UUID:(NSString *)UUID Mac:(NSData *)mac ProtocolID:(NSNumber *)protocolID  ECGCalGain:(NSNumber *)ECGCalGain;
@end

NS_ASSUME_NONNULL_END
