//
//  MicroLifeECGSettingValues.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/25.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeECGSettingValues : MicroLifeDataModel

// MARK: - Device Settings Properties

/// Bluetooth Control Switch
/// @discussion Controls the Bluetooth interface functionality, similar to airplane mode.
/// @note 0: Bluetooth interface enabled.
/// @note 1: Bluetooth interface disabled (changes take effect after disconnection).
@property (nonatomic, strong) NSNumber *SW_BT;

/// BP+ECG Measurement Mode
/// @discussion Controls automatic ECG measurement after a blood pressure reading.
/// @note 0: Blood pressure measurement only.
/// @note 1: Automatic ECG measurement triggered by arrhythmia detection after BP measurement.
@property (nonatomic, strong) NSNumber *SW_BPplusECG;

/// Frontend Filter Control
/// @discussion Controls the MAX3003 frontend filter functionality.
/// @note 0: Frontend filter disabled.
/// @note 1: Frontend filter enabled.
@property (nonatomic, strong) NSNumber *SW_max3003_filter;

/// Lead Detect Control
/// @discussion Controls the deactivation of lead detection. Primarily for factory testing to bypass standard connection checks.
/// @note 0: Lead detection enabled (Default).
/// @note 1: Lead detection disabled (Factory use only).
@property (nonatomic, strong) NSNumber *SW_turnOff_leaddetect;

/// ECG Measurement Duration (Continuous)
/// @discussion Controls ECG measurement time logic and data storage behavior.
/// @note 0: Fixed duration (30/60s) with data stored to flash memory.
/// @note 1: Unlimited duration for testing; data is NOT stored to flash.
@property (nonatomic, strong) NSNumber *SW_continued_ECG;

/// Buzzer Control
/// @discussion Controls the device's buzzer/beeping functionality.
/// @note 0: All buzzer functions disabled (Silent).
/// @note 1: Buzzer features enabled.
@property (nonatomic, strong) NSNumber *SW_BeepOn;

/// Afib Control
/// @discussion Determines if Atrial Fibrillation (Afib) detection is active during blood pressure measurements.
/// @note 0: Disable Afib detection during BP measurement.
/// @note 1: Enable Afib detection during BP measurement.
@property (nonatomic, strong) NSNumber *SW_Afib;

/// MAM Rest Duration
/// @discussion Controls the rest period countdown between MAM measurements.
/// @note 0: MAM rest disabled.
/// @note 60: 1 minute rest period.
/// @note 180: 3 minutes rest period.
/// @note 300: 5 minutes rest period.
@property (nonatomic, assign) MAMRest MAMRest;

/// ECG Sample Length
/// @discussion Controls the fixed duration for ECG sampling.
/// @note 0: N/A
/// @note 1: 30 seconds
/// @note 2: 60 seconds
/// @note 9: 540 seconds (Factory Test)
/// @note 31: 1830 seconds (Factory Test)
@property (nonatomic, assign) SsampleTime length;

/// MAM Measurement Interval
/// @discussion Controls the interval setting for MAM mode.
/// @note Supported values include: 15, 30, 60, 120 seconds.
@property (nonatomic, assign) MAMInterval MAMInterval;

@end

NS_ASSUME_NONNULL_END
