//
//  MicroLifePFM.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2022/12/6.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger , CMDPFM) {
    CMDPFMReadHistorys = 0x00,
    CMDPFMClearAllHistorys = 0x03,
    CMDPFMDisconnect = 0x04,
    CMDPFMReadUserAndVersionData = 0x05,
    CMDPFMWriteUser = 0x06,
    CMDPFMReadLastData = 0x07,
    CMDPFMClearLastData = 0x08,
    CMDPFMReadDeviceTime = 0x0C,
    CMDPFMWriteDeviceTime = 0x0D,
    CMDPFMReadSerialNumber = 0x0F,
    CMDPFMReadBestValue = 0x10,
    CMDPFMWriteBestValue = 0x11,
    CMDPFMCheckMode = 0x12,
    CMDPFMWaveformModeStartMeasurement = 0x13,
    CMDPFMWaveformModeReadWaveform = 0x14,
    CMDPFMReplyACK = 0x81,
    CMDPFMReplyNACK = 0x91,
    CMDPFMReplyNullACK = 0x92
};

@interface MicroLifePFM : MicroLifeDevice

/// read all history or current data
-(void)readHistorys;

/// clear all history data
- (void)clearAllHistorys;

/// disconnect
- (void)disconnect;

/// read user id and version data
- (void)readUserAndVersionData;

/// write a new user id & age
/// @param ID userID (Must be a 9-digit string 2-english string)
/// @param age age
- (void)writeUserData:(NSString *)ID Age:(NSInteger)age;

///  read device Time
- (void)readDeviceTime;

/// write device time
- (void)writeDeviceTime;

/// read last 1 data from the BPM
- (void)readLastData;

/// clear last 1 data of the BPM
- (void)clearLastData;

/// read device SN
- (void)readSerialNumber;

///  read Best Value
- (void)readBestValue;

/// write Best Value
/// - Parameter bv: bv
- (void)writeBestValue:(NSInteger)bv;

/// Check Mode
- (void)checkMode;

/// Waveform Mode Start Measurement
- (void)waveformModeStartMeasurement;
@end

NS_ASSUME_NONNULL_END
