//
//  MicroLifeWS500.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2025/12/26.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDWS500) {
    CMDWS500WakeUpScale = 0x90,
    CMDWS500SleepScale = 0x91,
    CMDWS500SyncSystemClock = 0x98,
    CMDWS500QueryVersion = 0x9C,
    CMDWS500MeasurementResult = 0x9E,
    CMDWS500ReadHistorys = 0xA0,
    CMDWS500LowPower = 0xA4,
    CMDWS500UploadCompleted = 0xA9,
    CMDWS500UpdateUserInfo = 0xB0,
    CMDWS500ClearAllUserInfo = 0xB1,
    CMDWS500ReadUserInfo = 0xB3
};


@interface MicroLifeWS500 : MicroLifeDevice


/// writeUserData
/// @param index Index
/// @param ID ID
/// @param age age
/// @param gender gender
/// @param height height
/// @param unitType unitType
/// @param weight weight
/// @param resistance resistance
- (void)writeUserData:(NSInteger)index ID:(NSString *)ID Age:(NSInteger)age Gender:(MicroLifeUserGender)gender Height:(NSInteger)height UnitType:(MicroLifeEBUnitType)unitType Weight:(float)weight Resistance:(NSInteger)resistance;

/// read all history or current data
/// @param index Index
/// @param ID ID
- (void)readHistorys:(NSInteger)index ID:(NSString *)ID;

/// read Users information
/// @param index index 01~08
- (void)readUsers:(NSInteger)index;

/// Clear All Users
- (void)clearAllUsers;

/// disconnect
- (void)disconnect;

/// read Device information
- (void)queryVersion;

/// Synchronize device time
- (void)syncTiming;
@end
