//
//  MicroLifeWatchBPCurrentAndMData.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/5.
// 

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPCurrentAndMData : MicroLifeDataModel
/**
 Systolic
 */
@property (nonatomic, strong) NSNumber *sys;

/**
 Diastolic
 */
@property (nonatomic, strong) NSNumber *dia;

/**
 Pulse
 */
@property (nonatomic, strong) NSNumber *hr;

/**
 Year
 */
@property (nonatomic, strong) NSNumber *year;

/**
 Month
 */
@property (nonatomic, strong) NSNumber *month;

/**
 Date
 */
@property (nonatomic, strong) NSNumber *day;

/**
 Hour
 */
@property (nonatomic, strong) NSNumber *hour;

/**
 Minte
 */
@property (nonatomic, strong) NSNumber *minute;

/**
 the data detect with PAD  or Afib
 */
@property (nonatomic, strong) NSNumber *arr;

/**
 IHB
 */
@property (nonatomic, strong) NSNumber *IHB;

/**
 AFIb (If both detect Afib and IHB, only display Afib)
 */
@property (nonatomic, strong) NSNumber *AFIb;

/**
 the data is measured in usual mode
 */
@property (nonatomic, strong) NSNumber *usual;

/**
 the data is measured in diagnostic mode
 */
@property (nonatomic, strong) NSNumber *diagnostic;

/**
 the data is measured in night with diagnostic mode (ex. 4:00~12:00)
 */
@property (nonatomic, strong) NSNumber *AM;

/**
 the data is measured in morning with diagnostic mode (ex. 18:00~24:00)
 */
@property (nonatomic, strong) NSNumber *PM;

@property (nonatomic, strong) NSNumber *ABPM;
/**
 low battery
 */
@property (nonatomic, strong) NSNumber *LB;
/**
 anti-artifact detected
 */
@property (nonatomic, strong) NSNumber *AA;
/**
 start of a manual measurement
 */
@property (nonatomic, strong) NSNumber *SM;

//WatchBPO3 & WatchBPOffice
/**
 Condition
 0     BP
 1     BP +CBP
 2     Empty battery
 3     Error code for original BP
 4     stop measurement by manual
 5     Pill memo
 6     device switch off
 7     re-start during a 24h-profile
 10    Retry 1st -BP
 11    Retry 1st -BP+CBP
 12    Retry 1st -Empty battery
 13    Retry 1st -Error code for original BP
 14    Retry 1st -stop measurement by manual
 20    Retry 2nd -BP
 21    Retry 2nd -BP+CBP
 22    Retry 2nd -Empty battery
 23    Retry 2nd - Error code for original BP
 24    Retry 2nd - stop measurement by manual
 */
@property (nonatomic, strong) NSNumber *condition;

/**
 * Mean Arterial Pressure
 */
@property (nonatomic, strong) NSNumber *MAP;

/**
 * Mean Central Blood Pressure
 */
@property (nonatomic, strong) NSNumber *MCBP;

/**
 * Peripheral Vascular Resistance
 */
@property (nonatomic, strong) NSNumber *PVR;

/**
 * Central Systolic Blood Pressure
 */
@property (nonatomic, strong) NSNumber *CSBP;

/**
 * Central Pulse Pressure
 */
@property (nonatomic, strong) NSNumber *CPP;

/**
 Result Code    Error Code     Error Message    Description
 0x01           0x01           Error 1          Signals is too weak
 0x02           0x02           Error 2          Error signal
 0x03           0x03           Error 3          No pressure in the cuff
 0x05           0x05           Error 5          Abnormal result
 0x11           0x11           Error 11         Signal too weak during central blood pressure measuremen
 
 0x12           0x12           Error 12         Error signal during central blood pressure measurement
 
 0x13           0x13           Error 13         Cuff pressure errors during  central blood pressure measurement
 
 0x15           0x15           Error 15         Abnormal result of central blood pressure reading
 
 0x41           0x41           Error A          Flash memory error
 0x42                          Error B          Low battery
 0x46           0x46           Error F          The device has gone into “single fault condition”
 
 0x50           0x50           Error P          Manual stop measurement.
 0x51           0x51           Error A / Q      Failed to initialize system / Busy
 0x52           0x52           Error R          Past time
 */
@property (nonatomic, strong) NSNumber *errorCode;
@property (nonatomic, strong) NSNumber *resultCode;
@property (nonatomic, strong) NSString *errorMessage;

//WatchBP Office Vascular
/**
 * Right arm condition code
 * Mode: 0-6, 254: N/A
 */
@property (nonatomic, assign) ConditionMode R_Condition;

/**
 * Right arm systolic pressure (mmHg) or error code
 * 0: N/A
 * Check R_Status bit3 for error measurement
 */
@property (nonatomic, strong) NSNumber *R_SYS;

/**
 * Right arm diastolic pressure (mmHg)
 */
@property (nonatomic, strong) NSNumber *R_DIA;

/**
 * Right arm formula MAP (mmHg)
 * Calculated as: 1/3 (R_SYS) + 1/2 (R_DIA)
 */
@property (nonatomic, strong) NSNumber *R_Formula_MAP;

/**
 * Right arm status flags
 */
@property (nonatomic, strong) NSNumber *R_Status;

/**
 * Right arm oscillometric mean arterial pressure (mmHg)
 */
@property (nonatomic, strong) NSNumber *R_Oscillometric_MAP;

/**
 * Right arm mean central blood pressure data
 * Calculated from high and low bytes
 */
@property (nonatomic, strong) NSNumber *R_mean_cbp_data;

/**
 * Right arm PVR length
 * Calculated from high and low bytes
 */
@property (nonatomic, strong) NSNumber *R_PVR_length;

/**
 * Right arm central systolic blood pressure (mmHg) or CBP error code
 * Check M_CBP for CBP availability
 * Check R_Status bit3 for error measurement
 * Check R_Status bit2 or bytes 10-13=0xff to identify CBP error code
 */
@property (nonatomic, strong) NSNumber *R_CSBP;

/**
 * Right arm central pulse pressure (mmHg)
 */
@property (nonatomic, strong) NSNumber *R_CPP;

/**
 * Right CDBP = right CSBP - right CPP
 */
@property (nonatomic, strong) NSNumber *R_CDBP;

/**
 * Left arm condition code
 * Mode: 0-6, 254: N/A
 */
@property (nonatomic, assign) ConditionMode L_Condition;

/**
 * Left arm systolic pressure (mmHg) or error code
 * 0: N/A
 * Check L_Status bit3 for error measurement
 */
@property (nonatomic, strong) NSNumber *L_SYS;

/**
 * Left arm diastolic pressure (mmHg)
 */
@property (nonatomic, strong) NSNumber *L_DIA;

/**
 * Left arm formula MAP (mmHg)
 * Calculated as: 1/3 (L_SYS) + 1/2 (L_DIA)
 */
@property (nonatomic, strong) NSNumber *L_Formula_MAP;

/**
 * Left arm status flags
 */
@property (nonatomic, strong) NSNumber *L_Status;

/**
 * Left arm oscillometric mean arterial pressure (mmHg)
 */
@property (nonatomic, strong) NSNumber *L_Oscillometric_MAP;

/**
 * Left arm mean central blood pressure data
 * Calculated from high and low bytes
 */
@property (nonatomic, strong) NSNumber *L_mean_cbp_data;

/**
 * Left arm PVR length
 * Calculated from high and low bytes
 */
@property (nonatomic, strong) NSNumber *L_PVR_length;

/**
 * Left arm central systolic blood pressure (mmHg) or CBP error code
 * Check M_CBP for CBP availability
 * Check L_Status bit3 for error measurement
 * Check L_Status bit2 or bytes 27-29=0xff to identify CBP error code
 */
@property (nonatomic, strong) NSNumber *L_CSBP;

/**
 * Left arm central pulse pressure (mmHg)
 */
@property (nonatomic, strong) NSNumber *L_CPP;

/**
 * Left CDBP = left CSBP - left CPP
 */
@property (nonatomic, strong) NSNumber *L_CDBP;

/**
 * Current measurement number (1-6)
 */
@property (nonatomic, strong) NSNumber *currentMeasureNumber;

/**
 * Ankle-Brachial Index
 * Calculated as (ABI_H*256+ABI_L)/100
 * Check M_ABI for ABI availability
 * 0: N/A
 */
@property (nonatomic, strong) NSNumber *ABI;

/**
 * Pulse Transit Time (ms)
 * Calculated as (PTT_H*256+PTT_L)
 * Check M_PWV for PWV availability
 * Check L_Status bit3=0 & R_Status bit3=0 (without BP error)
 * Check ABI Error Code=0
 * 0: N/A
 */
@property (nonatomic, strong) NSNumber *PTT;

/**
 * Brachial-Ankle Pulse Wave Velocity (cm/s)
 * Calculated as (PWV_H*256+PWV_L)
 * Check M_PWV for PWV availability
 * Check L_Status bit3=0 & R_Status bit3=0 (without BP error)
 * Check ABI Error Code=0
 * If PWV<800 or PWV>2400, device will display E25
 */
@property (nonatomic, strong) NSNumber *PWV;

/**
 * Patient height (cm)
 * Range: 120-210 cm
 */
@property (nonatomic, strong) NSNumber *height;

/**
 IAD warning Right side
 */
@property (nonatomic, strong) NSNumber *IAD_R;

/**
 IAD warning left side
 */
@property (nonatomic, strong) NSNumber *IAD_L;

/**
 * ABI Error Code
 * Possible values: 0, 21, 23, 25
 */
@property (nonatomic, strong) NSNumber *ABIErrorCode;

/**
 measure with Afib detection
 */
@property (nonatomic, strong) NSNumber *M_Afib;

/**
 measure with CBP detection
 */
@property (nonatomic, strong) NSNumber *M_CBP;

/**
 measure with ABI detection
 */
@property (nonatomic, strong) NSNumber *M_ABI;

/**
 measure with PWV detection
 */
@property (nonatomic, strong) NSNumber *M_PWV;

@end

NS_ASSUME_NONNULL_END
