//
//  MicroLifeWatchBPDRecord.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/5.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPDRecord : MicroLifeDataModel
/**
 Mode:The Value Of This Flag Is fixed to 0x00
 */
@property (nonatomic, strong) NSNumber *mode;

/**
 History mode
 Raw data:    description    description
 0            RA             right arm
 1            LA             left arm
 2            RALA           right arm & left arm
 3            RALL           right arm & left leg
 4            RARL           right arm & right leg
 5            LARL           left arm & right leg
 6            LALL           left arm & left leg
 */
@property (nonatomic, assign) ConditionMode historyMode;

/**
 CurrentMode:
 0: BP_Single_MODE
 1: BP_Single_MODE + SW Afib ON 
 2: BP_MAM_MODE
 3: BP_MAM_MODE + SW Afib ON
 */
@property (nonatomic, strong) NSNumber *noOfCurrentMeasurement;

/**
 History Measurement times:
 PUBLIC COMMUNICATION SPECIFICATION FOR BLE /USB
 The history measurement times store in memory.
 */
@property (nonatomic, strong) NSNumber *historyMeasurementNumber;

/// Total package number :
/// If “total package number” >=2, there should be multi packages to send. Distinguish each package by “package number” and wait data transmit until receive last package which
@property (nonatomic, strong) NSNumber *totalPackageNumber;

/// Package number :
/// “package number” is equal to “Total package number”. Only “DRecord” will be divided by multi package.
@property (nonatomic, strong) NSNumber *packageNumber;

/**
 UserNumber:User1=1,User2=2,Guest=3
 */
@property (nonatomic, strong) NSNumber *userNumber;

/**
 MAMversion:0x00=MAMweight,0x01=MAMlight,0Xff=NoMAMfunction.
 The MAM result is calculated by simple arithmetic mean (MAM light) or weighted mean (MAM weight).
 */
@property (nonatomic, strong) NSNumber *MAMState;

/**
Average calculation when measurement:
Send Average calculation when measurement to APP.
0x01：Average is not include first memory data when measurement.
0x00：Average is include first memory data when measurement.
*/
@property (nonatomic, strong) NSNumber *Average;

/**
 measure with Afib detection
 */
@property (nonatomic, strong) NSNumber *M_Afib;

/**
 measure with CBP detection
 */
@property (nonatomic, strong) NSNumber *M_CBP;

/**
 measure with ABI detection
 */
@property (nonatomic, strong) NSNumber *M_ABI;

/**
 measure with PWV detection
 */
@property (nonatomic, strong) NSNumber *M_PWV;

/**
 measure with D-1 function (calculate average exclude 1st data)
 */
@property (nonatomic, strong) NSNumber *M_D1;

/**
 Newest blood pressure measurement data[Reserved]
 */
@property (nonatomic, strong) NSMutableArray *currentData;

/**
 All blood pressure menasurement data
 */
@property (nonatomic, strong) NSMutableArray *MData;

@end

NS_ASSUME_NONNULL_END
