//
//  MicroLifeWatchBPHome.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/5.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDWatchBPHome) {
    CMDWatchBPHomeReadUsualModeHistoryData = 0x00,
    CMDWatchBPHomeReadUsualModeHistoryDataIncludeEachMeasurement = 0x00F1,
    CMDWatchBPHomeReadDiagnosticModeHistoryData = 0x01,
    CMDWatchBPHomeClearHistoryDataMode = 0x02,
    CMDWatchBPHomeClearCurrentModeHistoryData = 0x03,
    CMDWatchBPHomeDisconnect = 0x04,
    CMDWatchBPHomeWriteDeviceTime = 0x05,
    CMDWatchBPHomeWriteUserID = 0x06,
    CMDWatchBPHomeReadNocturnalModeSetting = 0x0701,
    CMDWatchBPHomeChangeNocturnalMode = 0x0702,
    CMDWatchBPHomeReadDeviceSettingOfMeasurement = 0x0800,
    CMDWatchBPHomeWriteDeviceSettingOfMeasurement = 0x0801,
    CMDWatchBPHomeReadDeviceInfo = 0x0B,
    CMDWatchBPHomeReadDeviceTime = 0x0C,
    CMDWatchBPHomeReadUserAndVersionData = 0x0D,
    CMDWatchBPHomeReadNocturnalModeHistoryData = 0x0E,
    CMDWatchBPHomeReadSerialNumber = 0x0F,
    CMDWatchBPHomeReplyACK = 0x81,
    CMDWatchBPHomeReplyNACK = 0x91,
    CMDWatchBPHomeReplyNullACK = 0x92
};

typedef NS_ENUM(NSInteger , MeasurementTimes) {
    MeasurementTime1 = 1,
    MeasurementTime2 = 2,
    MeasurementTime3 = 3
};

typedef NS_ENUM(NSInteger , RestIntervalTime) {
    RestIntervalTimeSkipRest,
    RestIntervalTime15Seconds,
    RestIntervalTime30Seconds,
    RestIntervalTime60Seconds,
    RestIntervalTime120Seconds,
    RestIntervalTime180Seconds,
    RestIntervalTime240Seconds,
    RestIntervalTime300Seconds
};

typedef NS_ENUM(NSInteger , ExcludeAverage) {
    AverageAllMeasurements = 0, ///average all measurements
    AverageExcludes1stMeasurement = 1   ///average excludes 1st measurement
};

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPHome : MicroLifeDevice

/**
 Read usual mode history data from BPM
 */
- (void)readUsualModeHistoryData;

/**
 Read usual mode history data (include each measurement) from BPM
 */
- (BOOL)readUsualModeHistoryDataIncludeEachMeasurement;

/**
 Read diagnostic mode history data from BPM
 */
- (void)readDiagnosticModeHistoryData;

/**
 Clear selected mode history data of the BPM

 @param clearUsualMode clear Usual Mode
 @param clearDiagnosticlMode clear Diagnosticl Mode
 @param clearNocturnalMode clear Nocturnal Mode
 */
- (void)clearHistoryDataWithSelectedUsualMode:(BOOL)clearUsualMode DiagnosticMode:(BOOL)clearDiagnosticlMode NocturnalMode:(BOOL)clearNocturnalMode;

/**
 Clear current mode history data of the BPM
 */
- (void)clearCurrentModeHistoryData;

/**
 Disconnect the Bluetooth with BPM
 */
- (void)disconnect;

/**
 Write device Time to BPM
 */
- (void)writeDeviceTime;

/**
 Write a new user ID to BPM
 
 @param ID user ID
 */
- (void)writeUserID:(NSString *)ID;

/**
 Read nocturnal mode setting
 */
- (void)readNocturnalModeSetting;

/**
 Change nocturnal mode setting
 Note : This command requires matching hardware to set. You can use "readDeviceIDAndInfo(MicroLifeDeviceInfo.openNocturnalMode)" to check if the device supports it.

 @param open Nocturnal ON/OFF
 @param year year
 @param month month
 @param day day
 @param hour hour
 */
- (void)changeNocturnalModeSettingOn:(BOOL)open StartYear:(NSInteger)year StartMonth:(NSInteger)month StartDay:(NSInteger)day StartHour:(NSInteger)hour;

/// Read measurement setting
- (BOOL)readDeviceSettingOfMeasurement;

/// Write measurement setting
/// @param measurementTimes Measurement times: (Default = MeasurementTime3) It’s the measurement times (1~3) for usual mode.
/// @param restTime Rest time: (Default = RestIntervalTime) It’s interval before 1st measurement.
/// @param intervalTime Interval time: (Default = RestIntervalTime15Seconds) It’s interval between each measurement.
/// @param excludeAverage Exclude average: (Default = AverageAllMeasurements)
/// @param SW_Afib SW_Afib enable the Afib function. (this setting is valid with the Afib option enable in “BPMSetting2”.)
- (BOOL)writeDeviceSettingOfMeasurement:(MeasurementTimes)measurementTimes RestTime:(RestIntervalTime)restTime IntervalTime:(RestIntervalTime)intervalTime ExcludeAverage:(ExcludeAverage)excludeAverage SWAfib:(BOOL)SW_Afib;
/**
 Read device ID and info from BPM
 */
- (void)readDeviceIDAndInfo;

/**
 Read device Time from BPM
 */
- (void)readDeviceTime;

/**
 Read user ID and version data from BPM
 */
- (void)readUserAndVersionData;

/**
 Read Nocturnal mode history data from BPM,If memory bank is blank, BPM will respond NullACK
 */
- (void)readNocturnalModeHistoryData;

/**
  Read device SN from BPM

 */
- (void)readSerialNumber;
@end

NS_ASSUME_NONNULL_END
