//
//  MicroLifeWatchBPOffice.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/5.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDWatchBPOffice) {
    CMDWatchBPOfficeReadHistorys = 0x00,
    CMDWatchBPOfficeReadCBPData = 0x01,
    CMDWatchBPOfficeClearAllHistorys = 0x03,
    CMDWatchBPOfficeDisconnect = 0x04,
    CMDWatchBPOfficeReadUserAndVersionData = 0x05,
    CMDWatchBPOfficeWriteUser = 0x06,
    CMDWatchBPOfficeReadSettingValues = 0x07,
    CMDWatchBPOfficeWriteSettingValues = 0x08,
    CMDWatchBPOfficeReadDeviceInfo = 0x0B,
    CMDWatchBPOfficeReadDeviceTime = 0x0C,
    CMDWatchBPOfficeWriteDeviceTime = 0x0D,
    CMDWatchBPOfficeReadFunctionSettingValue = 0x10,
    CMDWatchBPOfficeReadBTModuleName = 0x13,
    CMDWatchBPOfficeStartRemoteMeasurement = 0x25,
    CMDWatchBPOfficeStopRemoteMeasurement = 0x26,
    CMDWatchBPOfficeSendRemoteMeasurementStatusEvery5seconds = 0x27,
    CMDWatchBPOfficeSendMeasurementResultsForEachMeasurement = 0x28,
    CMDWatchBPOfficeReplyACK = 0x81,
    CMDWatchBPOfficeReplyNACK = 0x91,
    CMDWatchBPOfficeReplyNullACK = 0x92
};

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPOffice : MicroLifeDevice

/**
 Read all history or current data from bpm
 */
- (void)readAllHistorys;

/**
 Read CBP data by index from BPM
 
 @param index Data format which APP requested
 @param dformat Data format which APP requested
 */
- (void)readCBPDataWithIndex:(NSInteger)index Dformat:(Dformat)dformat;

/**
 Clear all history data of the BPM
 */
- (void)clearAllHistorys;

/**
 Disconnect the Bluetooth with BPM
 */
- (void)disconnect;

/**
 Read user ID and version data from BPM
 */
- (void)readUserAndVersionData;

/**
 Write a new user ID to BPM
 
 @param ID user ID
 */
- (void)writeUserID:(NSString *)ID;

/**
 Read BPM setting values from BPM
 */
- (void)readSettingValues;

/// Write BPM setting values to BPM.
/// @param AUS_HI_infPressure Highest inflation pressure of AUS mode.
/// @param HI_infPressure Highest inflation pressure of Auto mode.
/// @param SW_AUTO_hide Set Show readings during rest time in auto mode. true:hide/false:show.
/// @param SW_SEL_silent Beeper true:enabled/false:disabled
/// @param SW_AUS_Hide Set Show cuff pressure during deflation in AUS mode. true:hide/false:show.
/// @param SW_AVG_no_include_first Set Average is include first memory data. true:is/false:is not.
/// @param SW_CBP Set CBP measurement  true:enabled/false:disabled.
/// @param SW_AFib Set AFib measurement  true:enabled/false:disabled.
/// @param SW_AMPM Set 12/24-hour clock true:12-hour/false:24-hour.
/// @param SW_Kpa Set Pressure unit: true:Kpa/false:mmHg.
/// @param RestTime Rest time of auto mode. Start countdown base on rest time before 1st measurement in auto mode.
/// @param IntervalTime Interval time of auto mode. Start countdown base on interval time before 2nd~6th measurement in auto mode.
/// @param AutoMeasureNumber It’s number of measurements in auto mode.

- (void)writeSettingValuesWithSelectedAUS_HI_infPressure:(HIinfPressure)AUS_HI_infPressure HI_infPressure:(HIinfPressure)HI_infPressure SW_AUTO_hide:(BOOL)SW_AUTO_hide SW_SEL_silent:(BOOL)SW_SEL_silent SW_AUS_Hide:(BOOL)SW_AUS_Hide SW_AVG_no_include_first:(BOOL)SW_AVG_no_include_first SW_CBP:(BOOL)SW_CBP SW_AFib:(BOOL)SW_AFib SW_AMPM:(BOOL)SW_AMPM SW_Kpa:(BOOL)SW_Kpa RestTime:(NSInteger)RestTime IntervalTime:(NSInteger)IntervalTime AutoMeasureNumber:(NSInteger)AutoMeasureNumber;

/**
 Read device ID and info from BPM
 */
- (void)readDeviceIDAndInfo;

/**
 Read device Time from BPM
 */
- (void)readDeviceTime;

/**
 Write device Time to BPM
 */
- (void)writeDeviceTime;

/**
 Read BPM function setting value from BPM
 */
- (void)readFunctionSettingValue;

/**
 Read BT module name from BPM
 */
- (void)readBTModuleName;

/**
 Start remote measurement
 
 @param dformat Data format which APP requested
 */
- (void)startRemoteMeasurementWhtihCBPFunction:(Dformat)dformat;

/**
 Stop remote measurement
 */
- (void)stopRemoteMeasurement;

@end

NS_ASSUME_NONNULL_END
